/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.worldgen.feature.configurations.MahoganyTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;

public class MahoganyTreeFeature
extends BOPTreeFeature<MahoganyTreeConfiguration> {
    public MahoganyTreeFeature(Codec<MahoganyTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean doPlace(WorldGenLevel world, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TreeConfiguration configBase) {
        MahoganyTreeConfiguration config = (MahoganyTreeConfiguration)configBase;
        int height = random.nextInt(config.maxHeight - config.minHeight) + config.minHeight;
        boolean hasSpace = true;
        if (pos.getY() >= world.getMinY() + 1 && pos.getY() + height + 1 <= world.getMaxY()) {
            for (int y = pos.getY(); y <= pos.getY() + 1 + height; ++y) {
                int radius = 1;
                if (y == pos.getY()) {
                    radius = 0;
                }
                if (y >= pos.getY() + 1 + height - 2) {
                    radius = 2;
                }
                for (int x = pos.getX() - radius; x <= pos.getX() + radius && hasSpace; ++x) {
                    for (int z = pos.getZ() - radius; z <= pos.getZ() + radius && hasSpace; ++z) {
                        if (y >= world.getMinY() && y < world.getMaxY()) {
                            if (this.canReplace((LevelAccessor)world, new BlockPos(x, y, z))) continue;
                            hasSpace = false;
                            continue;
                        }
                        hasSpace = false;
                    }
                }
            }
            if (!hasSpace) {
                return false;
            }
            BlockPos soilPos = pos.below();
            Block soil = world.getBlockState(soilPos).getBlock();
            if (pos.getY() < world.getMaxY() - height - 1) {
                world.setBlock(soilPos, Blocks.DIRT.defaultBlockState(), 3);
                this.generateTrunk(logs, leaves, (LevelAccessor)world, pos, height, config);
                return true;
            }
            return false;
        }
        return false;
    }

    protected void generateTrunk(BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, LevelAccessor world, BlockPos start, int height, MahoganyTreeConfiguration config) {
        int endHeight = height;
        for (int layer = 0; layer <= endHeight - 3; ++layer) {
            BlockPos middlePos = start.above(layer);
            if (!this.canReplace(world, middlePos)) continue;
            this.placeLog(world, middlePos, logs, config);
        }
        BlockPos branchStartPos = start.above(endHeight - 3);
        this.generateBranch(logs, leaves, world, branchStartPos, Direction.NORTH, config);
        this.generateBranch(logs, leaves, world, branchStartPos, Direction.EAST, config);
        this.generateBranch(logs, leaves, world, branchStartPos, Direction.SOUTH, config);
        this.generateBranch(logs, leaves, world, branchStartPos, Direction.WEST, config);
    }

    private void generateBranch(BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, LevelAccessor world, BlockPos middle, Direction direction, MahoganyTreeConfiguration config) {
        BlockPos pos = middle;
        int length = 1 + world.getRandom().nextInt(2);
        for (int i = 0; i <= length - 1; ++i) {
            if (!this.canReplace(world, pos.relative(direction, i + 1))) continue;
            this.placeLog(world, pos.relative(direction, i + 1), direction.getAxis(), logs, config);
        }
        int height = 1 + world.getRandom().nextInt(2);
        for (int i = 0; i <= height; ++i) {
            if (!this.canReplace(world, pos.relative(direction, length + 1).above(i + 1))) continue;
            this.placeLog(world, pos.relative(direction, length + 1).above(i + 1), Direction.Axis.Y, logs, config);
        }
        pos = pos.relative(direction, length + 1).above(height + 1);
        if (world.getRandom().nextInt(2) == 0) {
            this.placeLeaves(world, pos.offset(-1, -1, 0), leaves, config);
            this.placeLeaves(world, pos.offset(1, -1, 0), leaves, config);
            this.placeLeaves(world, pos.offset(0, -1, -1), leaves, config);
            this.placeLeaves(world, pos.offset(0, -1, 1), leaves, config);
        }
        for (int y = 0; y < 2; ++y) {
            int leavesRadius = 2 - y > 1 ? 2 : 1;
            for (int x = -leavesRadius; x <= leavesRadius; ++x) {
                for (int z = -leavesRadius; z <= leavesRadius; ++z) {
                    if (Math.abs(x) >= leavesRadius && Math.abs(z) >= leavesRadius && world.getRandom().nextInt(4) != 0) continue;
                    if (config.altFoliageProvider.getState(world.getRandom(), pos) != Blocks.AIR.defaultBlockState()) {
                        if (world.getRandom().nextInt(4) == 0) {
                            this.placeAltLeaves(world, pos.offset(x, y, z), leaves, config);
                            continue;
                        }
                        this.placeLeaves(world, pos.offset(x, y, z), leaves, config);
                        continue;
                    }
                    this.placeLeaves(world, pos.offset(x, y, z), leaves, config);
                }
            }
        }
    }
}

