/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.player;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.gui.GuiPlayerSelectorButton;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.util.registry.NamedTypeRegistry;

public abstract class PlayerSelector {
    public static final NamedTypeRegistry<PlayerSelector> REGISTRY = new NamedTypeRegistry().addConstructorPattern(new Class[0]);

    public static PlayerSelector read(CompoundTag nbt) {
        Class<PlayerSelector> clazz = REGISTRY.get(nbt.getStringOr("id", ""));
        if (clazz == null) {
            throw new RuntimeException("Could not find player selector for " + String.valueOf(nbt.getString("id")));
        }
        try {
            PlayerSelector selector = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            selector.readFromNBT(nbt);
            return selector;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("PlayerSelector type " + String.valueOf(nbt.getString("id")) + " does not have an empty constructor!");
        }
    }

    public abstract boolean is(Player var1);

    public abstract void readFromNBT(CompoundTag var1);

    protected abstract void write(CompoundTag var1);

    public abstract String info();

    public CompoundTag writeToNBT(CompoundTag nbt) {
        this.write(nbt);
        nbt.putString("id", REGISTRY.getId(this.getClass()));
        return nbt;
    }

    static {
        REGISTRY.register("and", PlayerSelectorAnd.class);
        REGISTRY.register("or", PlayerSelectorOr.class);
        REGISTRY.register("not", PlayerSelectorNot.class);
        REGISTRY.register("level", PlayerSelectorLevel.class);
        REGISTRY.register("mode", PlayerSelectorGamemode.class);
        REGISTRY.register("selector", PlayerSelectorCommandSelector.class);
        ConfigTypeConveration.registerSpecialType(PlayerSelector.class::isAssignableFrom, new ConfigTypeConveration.SimpleConfigTypeConveration<PlayerSelector>(){

            @Override
            public PlayerSelector readElement(ConfigKey key, PlayerSelector defaultValue, Side side, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    try {
                        return PlayerSelector.read(TagParser.parseCompoundFully((String)element.getAsString()));
                    }
                    catch (CommandSyntaxException e) {
                        CreativeCore.LOGGER.error((Object)e);
                    }
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(PlayerSelector value, ConfigKey key, Side side) {
                return new JsonPrimitive(value.writeToNBT(new CompoundTag()).toString());
            }

            @Override
            public void createControls(GuiParent parent, ConfigKey key) {
                parent.add((GuiControl)new GuiPlayerSelectorButton((IGuiParent)parent, "data", new PlayerSelectorLevel(0)));
            }

            @Override
            public void loadValue(PlayerSelector value, GuiParent parent) {
                GuiPlayerSelectorButton button = (GuiPlayerSelectorButton)parent.get("data");
                button.set(value);
            }

            @Override
            protected PlayerSelector saveValue(GuiParent parent, ConfigKey key) {
                GuiPlayerSelectorButton button = (GuiPlayerSelectorButton)parent.get("data");
                return button.get();
            }

            @Override
            public PlayerSelector set(ConfigKey key, PlayerSelector value) {
                return value;
            }
        });
    }

    public static class PlayerSelectorAnd
    extends PlayerSelector {
        public PlayerSelector[] selectors;

        public PlayerSelectorAnd() {
        }

        public PlayerSelectorAnd(PlayerSelector ... selector) {
            this.selectors = selector;
        }

        @Override
        public boolean is(Player player) {
            for (int i = 0; i < this.selectors.length; ++i) {
                if (this.selectors[i].is(player)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void readFromNBT(CompoundTag nbt) {
            ListTag list = nbt.getListOrEmpty("selectors");
            this.selectors = new PlayerSelector[list.size()];
            for (int i = 0; i < this.selectors.length; ++i) {
                this.selectors[i] = PlayerSelector.read(list.getCompoundOrEmpty(i));
            }
        }

        @Override
        protected void write(CompoundTag nbt) {
            ListTag list = new ListTag();
            for (int i = 0; i < this.selectors.length; ++i) {
                list.add((Object)this.selectors[i].writeToNBT(new CompoundTag()));
            }
            nbt.put("selectors", (Tag)list);
        }

        @Override
        public String info() {
            StringBuilder text = new StringBuilder("[");
            for (int i = 0; i < this.selectors.length; ++i) {
                if (i > 0) {
                    text.append("&");
                }
                text.append(this.selectors[i].info());
            }
            return String.valueOf(text) + "]";
        }
    }

    public static class PlayerSelectorOr
    extends PlayerSelector {
        public PlayerSelector[] selectors;

        public PlayerSelectorOr() {
        }

        public PlayerSelectorOr(PlayerSelector ... selector) {
            this.selectors = selector;
        }

        @Override
        public boolean is(Player player) {
            for (int i = 0; i < this.selectors.length; ++i) {
                if (!this.selectors[i].is(player)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void readFromNBT(CompoundTag nbt) {
            ListTag list = nbt.getListOrEmpty("selectors");
            this.selectors = new PlayerSelector[list.size()];
            for (int i = 0; i < this.selectors.length; ++i) {
                this.selectors[i] = PlayerSelector.read(list.getCompoundOrEmpty(i));
            }
        }

        @Override
        protected void write(CompoundTag nbt) {
            ListTag list = new ListTag();
            for (int i = 0; i < this.selectors.length; ++i) {
                list.add((Object)this.selectors[i].writeToNBT(new CompoundTag()));
            }
            nbt.put("selectors", (Tag)list);
        }

        @Override
        public String info() {
            StringBuilder text = new StringBuilder("[");
            for (int i = 0; i < this.selectors.length; ++i) {
                if (i > 0) {
                    text.append("|");
                }
                text.append(this.selectors[i].info());
            }
            return String.valueOf(text) + "]";
        }
    }

    public static class PlayerSelectorNot
    extends PlayerSelector {
        public PlayerSelector selector;

        public PlayerSelectorNot() {
        }

        public PlayerSelectorNot(PlayerSelector selector) {
            this.selector = selector;
        }

        @Override
        public boolean is(Player player) {
            return !this.selector.is(player);
        }

        @Override
        public void readFromNBT(CompoundTag nbt) {
            this.selector = PlayerSelector.read(nbt.getCompoundOrEmpty("child"));
        }

        @Override
        protected void write(CompoundTag nbt) {
            nbt.put("child", (Tag)this.selector.writeToNBT(new CompoundTag()));
        }

        @Override
        public String info() {
            return "!" + this.selector.info();
        }
    }

    public static class PlayerSelectorLevel
    extends PlayerSelector {
        public int permissionLevel;

        public PlayerSelectorLevel() {
        }

        public PlayerSelectorLevel(int permissionLevel) {
            this.permissionLevel = permissionLevel;
        }

        @Override
        public boolean is(Player player) {
            if (player instanceof ServerPlayer) {
                ServerOpListEntry entry = (ServerOpListEntry)player.level().getServer().getPlayerList().getOps().get((Object)player.nameAndId());
                if (entry != null) {
                    return entry.getLevel() >= this.permissionLevel;
                }
                return player.level().getServer().operatorUserPermissionLevel() >= this.permissionLevel;
            }
            return true;
        }

        @Override
        public void readFromNBT(CompoundTag nbt) {
            this.permissionLevel = nbt.getIntOr("level", 0);
        }

        @Override
        protected void write(CompoundTag nbt) {
            nbt.putInt("level", this.permissionLevel);
        }

        @Override
        public String info() {
            return "level>=" + this.permissionLevel;
        }
    }

    public static class PlayerSelectorGamemode
    extends PlayerSelector {
        public GameType type;

        public PlayerSelectorGamemode() {
        }

        public PlayerSelectorGamemode(GameType type) {
            this.type = type;
        }

        @Override
        public boolean is(Player player) {
            return player.gameMode() == this.type;
        }

        @Override
        public void readFromNBT(CompoundTag nbt) {
            this.type = GameType.byId((int)nbt.getIntOr("mode", 0));
        }

        @Override
        protected void write(CompoundTag nbt) {
            nbt.putInt("mode", this.type.getId());
        }

        @Override
        public String info() {
            return this.type.getName();
        }
    }

    public static class PlayerSelectorCommandSelector
    extends PlayerSelector {
        public String pattern;

        public PlayerSelectorCommandSelector() {
        }

        public PlayerSelectorCommandSelector(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean is(Player player) {
            try {
                if (player instanceof ServerPlayer) {
                    return EntityArgument.players().parse(new StringReader(this.pattern)).findPlayers(player.level().getServer().createCommandSourceStack()).contains(player);
                }
                return true;
            }
            catch (CommandSyntaxException commandSyntaxException) {
                return false;
            }
        }

        @Override
        public void readFromNBT(CompoundTag nbt) {
            this.pattern = nbt.getStringOr("pattern", "");
        }

        @Override
        protected void write(CompoundTag nbt) {
            nbt.putString("pattern", this.pattern);
        }

        @Override
        public String info() {
            return this.pattern;
        }
    }
}

