/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.mc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class JsonUtils {
    public static void set(JsonObject root, String[] path, String key, JsonElement element) {
        JsonUtils.get(root, path).add(key, element);
    }

    public static JsonObject tryGet(JsonObject root, String[] path) {
        JsonObject current = root;
        for (int i = 0; i < path.length; ++i) {
            JsonElement e;
            if (current.has(path[i])) {
                e = current.get(path[i]);
                if (!e.isJsonObject()) {
                    throw new RuntimeException("Could not create path " + Arrays.toString(path) + " in " + String.valueOf(root));
                }
            } else {
                return null;
            }
            current = (JsonObject)e;
        }
        return current;
    }

    public static JsonObject get(JsonObject root, String[] path) {
        JsonObject current = root;
        for (int i = 0; i < path.length; ++i) {
            if (current.has(path[i])) {
                JsonElement e = current.get(path[i]);
                if (e.isJsonObject()) {
                    current = (JsonObject)e;
                    continue;
                }
                throw new RuntimeException("Could not create path " + Arrays.toString(path) + " in " + String.valueOf(root));
            }
            JsonObject newObject = new JsonObject();
            current.add(path[i], (JsonElement)newObject);
            current = newObject;
        }
        return current;
    }

    public static boolean cleanUp(JsonObject json) {
        Iterator iterator = json.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry type = (Map.Entry)iterator.next();
            if (!(type.getValue() instanceof JsonObject) || !JsonUtils.cleanUp((JsonObject)type.getValue())) continue;
            iterator.remove();
        }
        return json.size() == 0;
    }

    public static JsonObject of(CompoundTag compound) {
        JsonObject o = new JsonObject();
        for (String id : compound.keySet()) {
            o.add(id, JsonUtils.of(compound.get(id)));
        }
        return o;
    }

    public static JsonElement of(Tag tag) {
        if (tag instanceof DoubleTag) {
            DoubleTag d = (DoubleTag)tag;
            return new JsonPrimitive((Number)d.doubleValue());
        }
        if (tag instanceof FloatTag) {
            FloatTag f = (FloatTag)tag;
            return new JsonPrimitive((Number)Float.valueOf(f.floatValue()));
        }
        if (tag instanceof LongTag) {
            LongTag l = (LongTag)tag;
            return new JsonPrimitive((Number)l.longValue());
        }
        if (tag instanceof ShortTag) {
            ShortTag s = (ShortTag)tag;
            return new JsonPrimitive((Number)s.shortValue());
        }
        if (tag instanceof IntTag) {
            IntTag i = (IntTag)tag;
            return new JsonPrimitive((Number)i.intValue());
        }
        if (tag instanceof StringTag) {
            StringTag s = (StringTag)tag;
            return new JsonPrimitive((String)s.asString().get());
        }
        if (tag instanceof ByteTag) {
            ByteTag b = (ByteTag)tag;
            byte value = (Byte)b.asByte().get();
            if (value == 0 || value == 1) {
                return new JsonPrimitive(Boolean.valueOf(value != 0));
            }
            return new JsonPrimitive((Number)value);
        }
        if (tag instanceof EndTag) {
            throw new IllegalArgumentException("End tag is not supported in JSON");
        }
        if (tag instanceof ByteArrayTag) {
            ByteArrayTag bArray = (ByteArrayTag)tag;
            JsonArray array = new JsonArray(bArray.size());
            byte[] content = bArray.getAsByteArray();
            for (int i = 0; i < content.length; ++i) {
                array.add((Number)content[i]);
            }
            return array;
        }
        if (tag instanceof IntArrayTag) {
            IntArrayTag iArray = (IntArrayTag)tag;
            JsonArray array = new JsonArray(iArray.size());
            int[] content = iArray.getAsIntArray();
            for (int i = 0; i < iArray.size(); ++i) {
                array.add((Number)content[i]);
            }
            return array;
        }
        if (tag instanceof LongArrayTag) {
            LongArrayTag lArray = (LongArrayTag)tag;
            JsonArray array = new JsonArray(lArray.size());
            long[] content = lArray.getAsLongArray();
            for (int i = 0; i < lArray.size(); ++i) {
                array.add((Number)content[i]);
            }
            return array;
        }
        if (tag instanceof ListTag) {
            ListTag l = (ListTag)tag;
            JsonArray array = new JsonArray(l.size());
            for (int i = 0; i < l.size(); ++i) {
                array.add(JsonUtils.of(l.get(i)));
            }
            return array;
        }
        return JsonUtils.of((CompoundTag)tag);
    }
}

