/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.tree;

import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.parent.GuiScrollXY;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.control.tree.GuiTreeDragPosition;
import team.creative.creativecore.common.gui.control.tree.GuiTreeItem;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.type.itr.NestedFunctionIterator;
import team.creative.creativecore.common.util.type.itr.TreeIterator;

public class GuiTree
extends GuiScrollXY {
    private boolean searchbar = false;
    private boolean checkboxes = false;
    private boolean checkboxesPartial = false;
    protected boolean canDeselect = true;
    private final GuiTextfield search;
    private boolean visibleRoot = false;
    private final GuiTreeItem root;
    private GuiTreeItem selected = null;

    public GuiTree(IGuiParent parent, String name) {
        this(parent, name, false);
    }

    public GuiTree(IGuiParent parent, String name, boolean searchbar) {
        super(parent, name, GuiFlow.STACK_Y);
        this.searchbar = searchbar;
        this.search = searchbar ? new GuiTextfield(this, name) : null;
        this.root = new GuiTreeItem((IGuiParent)this, "root", this);
        this.setSpacing(3);
        this.setLineThickness(1);
    }

    @Override
    public GuiTreeDist dist() {
        return (GuiTreeDist)super.dist();
    }

    public GuiTree setCheckboxes(boolean checkboxes, boolean partial) {
        boolean changed = checkboxes != this.checkboxes || partial != this.checkboxesPartial;
        this.checkboxes = checkboxes;
        this.checkboxesPartial = partial;
        if (changed) {
            for (GuiTreeItem item : this.allItems()) {
                if (!partial) {
                    item.resetCheckboxPartial();
                }
                item.updateControls();
            }
        }
        return this;
    }

    public GuiTree keepSelected() {
        this.canDeselect = false;
        return this;
    }

    public boolean canDeselect() {
        return this.canDeselect;
    }

    public boolean hasCheckboxes() {
        return this.checkboxes;
    }

    public boolean hasCheckboxesPartial() {
        return this.checkboxesPartial;
    }

    public Iterable<GuiTreeItem> allItems() {
        return new TreeIterator<GuiTreeItem>(this.root, x -> x.items().iterator());
    }

    public Iterable<GuiTreeItem> itemsChecked() {
        if (this.visibleRoot) {
            return this.root.itemsChecked();
        }
        return new NestedFunctionIterator<GuiTreeItem>(this.root.items(), GuiTreeItem::itemsChecked);
    }

    public GuiTreeItem selected() {
        return this.selected;
    }

    public GuiTreeItem getFirst() {
        if (this.visibleRoot) {
            return this.root;
        }
        if (this.root.itemsCount() > 0) {
            return this.root.getItem(0);
        }
        return null;
    }

    public boolean selectFirst() {
        if (this.visibleRoot) {
            this.select(this.root);
        } else if (this.root.itemsCount() > 0) {
            this.select(this.root.getItem(0));
        } else {
            this.select(null);
            return false;
        }
        return true;
    }

    public void select(GuiTreeItem item) {
        if (this.selected != null) {
            this.selected.deselect();
        }
        GuiTreeItem old = this.selected;
        this.selected = item;
        if (item != null) {
            item.select();
        }
        this.raiseEvent(new GuiTreeSelectionChanged(this, old, item));
    }

    public GuiTree setLineThickness(int thickness) {
        if (this.dist() != null) {
            this.dist().setLineThickness(thickness);
        }
        return this;
    }

    public GuiTree setRootVisibility(boolean visible) {
        this.visibleRoot = visible;
        return this;
    }

    public boolean isRootVisible() {
        return this.visibleRoot;
    }

    public GuiTreeItem root() {
        return this.root;
    }

    public void updateTree() {
        this.clear();
        if (this.searchbar) {
            this.add((GuiControl)this.search);
        }
        if (this.visibleRoot) {
            this.add((GuiControl)this.root);
        }
        if (!this.visibleRoot || this.root.opened()) {
            this.addItem(this.root);
        }
        if (this.dist() != null) {
            this.dist().reflowTree();
        }
    }

    private void addItem(GuiTreeItem item) {
        for (GuiTreeItem subItem : item.items()) {
            this.add((GuiControl)subItem);
            if (!subItem.opened()) continue;
            this.addItem(subItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performModication(GuiTreeItem item, GuiTreeDragPosition position) {
        if (item.isChild(position.item())) {
            return false;
        }
        try {
            item.setMoving(true);
            if (!item.getParentItem().removeItem(item)) {
                boolean bl = false;
                return bl;
            }
            position.insert(item);
        }
        finally {
            item.setMoving(false);
        }
        this.updateTree();
        return true;
    }

    public boolean moveUp() {
        if (this.selected == null) {
            return false;
        }
        GuiTreeItem parent = this.selected.getParentItem();
        if (parent == null) {
            return false;
        }
        int index = parent.indexOf(this.selected);
        if (index <= 0) {
            return false;
        }
        return this.performModication(this.selected, new GuiTreeDragPosition(GuiTreeDragPosition.ItemPosition.ABOVE, parent.getItem(index - 1), null));
    }

    public boolean moveDown() {
        if (this.selected == null) {
            return false;
        }
        GuiTreeItem parent = this.selected.getParentItem();
        if (parent == null) {
            return false;
        }
        int index = parent.indexOf(this.selected);
        if (index >= parent.itemsCount() - 1) {
            return false;
        }
        return this.performModication(this.selected, new GuiTreeDragPosition(GuiTreeDragPosition.ItemPosition.BELOW, parent.getItem(index + 1), null));
    }

    public boolean isDragged() {
        if (this.dist() != null) {
            return this.dist().isDragged();
        }
        return false;
    }

    public void startDrag(GuiTreeItem item) {
        if (this.dist() != null) {
            this.dist().startDrag(item);
        }
    }

    public boolean endDrag() {
        if (this.dist() != null) {
            return this.dist().endDrag();
        }
        return false;
    }

    public static interface GuiTreeDist
    extends GuiScrollXY.GuiScrollXYDist {
        public void reflowTree();

        public void setLineThickness(int var1);

        public boolean isDragged();

        public void startDrag(GuiTreeItem var1);

        public boolean endDrag();
    }

    public static class GuiTreeSelectionChanged
    extends GuiControlChangedEvent {
        public final GuiTreeItem previousSelected;
        public final GuiTreeItem selected;

        public GuiTreeSelectionChanged(GuiTree tree, GuiTreeItem previousSelected, GuiTreeItem selected) {
            super(tree);
            this.previousSelected = previousSelected;
            this.selected = selected;
        }
    }
}

