/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.timeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.timeline.GuiTimeline;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineKey;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;

public abstract class GuiTimelineChannel<T>
extends GuiParent {
    public final GuiTimeline timeline;
    public GuiControl sidebarTitle;
    private List<GuiTimelineKey<T>> keys = new ArrayList<GuiTimelineKey<T>>();

    public GuiTimelineChannel(GuiTimeline timeline) {
        super(timeline.getParent());
        this.timeline = timeline;
        this.setVAlign(VAlign.CENTER);
    }

    @Override
    public GuiTimelineChannelDist<T> dist() {
        return (GuiTimelineChannelDist)super.dist();
    }

    @Override
    public GuiTimelineChannel<T> setTooltip(List<Component> tooltip) {
        super.setTooltip(tooltip);
        this.sidebarTitle.setTooltip(tooltip);
        return this;
    }

    public GuiTimelineChannel<T> addKeyFixed(int tick, T value) {
        GuiTimelineKey<T> key = this.addKey(tick, value);
        key.modifiable = false;
        return this;
    }

    public GuiTimelineKey<T> addKey(int tick, T value) {
        GuiTimelineKey<T> key = new GuiTimelineKey<T>(this, tick, value);
        this.add((GuiControl)key);
        if (this.hasLayer() && this.dist() != null) {
            this.dist().keyInitialFlow(key);
        }
        this.timeline.adjustKeyPositionX(key);
        for (int i = 0; i < this.keys.size(); ++i) {
            GuiTimelineKey<T> other = this.keys.get(i);
            if (other.tick == tick) {
                return null;
            }
            if (other.tick <= tick) continue;
            this.keys.add(i, key);
            return key;
        }
        this.keys.add(key);
        this.timeline.raiseEvent(new GuiControlChangedEvent<GuiTimeline>(this.timeline));
        return key;
    }

    public void select(GuiTimelineKey<T> key) {
        this.timeline.selectKey(key);
    }

    public void deslect() {
        this.timeline.deselect();
    }

    public void removeChannel() {
        this.timeline.removeChannel(this);
    }

    public void removeKey(GuiTimelineKey<T> key) {
        this.keys.remove(key);
        this.remove(key);
        this.timeline.raiseEvent(new GuiControlChangedEvent<GuiTimeline>(this.timeline));
    }

    public void movedKey(GuiTimelineKey<T> key) {
        Collections.sort(this.keys);
        this.timeline.raiseEvent(new GuiControlChangedEvent<GuiTimeline>(this.timeline));
    }

    public void dragKey(GuiTimelineKey<T> key) {
        if (key.modifiable && this.dist() != null) {
            this.dist().dragKey(key);
        }
    }

    public boolean isSpaceFor(@Nullable GuiTimelineKey<T> key, int tick) {
        if (tick < 0 || tick > this.timeline.duration) {
            return false;
        }
        for (int i = 0; i < this.keys.size(); ++i) {
            int otherTick = this.keys.get((int)i).tick;
            if (otherTick == tick) {
                return false;
            }
            if (otherTick <= tick) continue;
            return true;
        }
        return true;
    }

    public abstract T getValueAt(int var1);

    public boolean isChannelEmpty() {
        return this.keys.isEmpty();
    }

    public Iterable<GuiTimelineKey<T>> keys() {
        return this.keys;
    }

    public GuiTimelineKey<T> getFirst() {
        if (this.keys.isEmpty()) {
            return null;
        }
        return this.keys.getFirst();
    }

    public GuiTimelineKey<T> getLast() {
        if (this.keys.isEmpty()) {
            return null;
        }
        return this.keys.getLast();
    }

    public static interface GuiTimelineChannelDist<K>
    extends GuiParent.GuiParentDistHandler {
        public void keyInitialFlow(GuiTimelineKey<K> var1);

        public void dragKey(GuiTimelineKey<K> var1);
    }
}

