/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.inventory;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.inventory.GuiSlot;
import team.creative.creativecore.common.gui.control.inventory.IGuiInventory;

public class GuiInventoryGrid
extends GuiParent
implements IGuiInventory {
    public final Container container;
    protected boolean hasFixedSize = true;
    protected int fixedSize;
    private boolean allChanged = false;
    private final BitSet changed = new BitSet();
    private List<Consumer<GuiSlot>> listeners;
    private final List<GuiSlot> slots = new ArrayList<GuiSlot>();

    public GuiInventoryGrid(IGuiParent parent, String name, Container container) {
        this(parent, name, container, (int)Math.ceil(Math.sqrt(container.getContainerSize())));
        this.hasFixedSize = false;
    }

    public GuiInventoryGrid(IGuiParent parent, String name, Container container, int cols) {
        this(parent, name, container, cols, (int)Math.ceil((double)container.getContainerSize() / (double)cols));
    }

    public GuiInventoryGrid(IGuiParent parent, String name, Container container, int cols, int rows) {
        this(parent, name, container, cols, rows, (c, i) -> new Slot(c, i.intValue(), 0, 0));
    }

    public GuiInventoryGrid(IGuiParent parent, String name, Container container, int cols, int rows, BiFunction<Container, Integer, Slot> slotFactory) {
        super(parent, name);
        if (this.dist() != null) {
            this.dist().setGridDim(cols, rows);
        }
        this.container = container;
        this.fixedSize = Math.min(container.getContainerSize(), cols * rows);
        this.createInventoryGrid(slotFactory);
    }

    @Override
    public GuiInventoryGridDist dist() {
        return (GuiInventoryGridDist)super.dist();
    }

    protected void createInventoryGrid(BiFunction<Container, Integer, Slot> slotFactory) {
        for (int i = 0; i < this.fixedSize; ++i) {
            this.addSlot(new GuiSlot((IGuiParent)this, slotFactory.apply(this.container, i)));
        }
    }

    public GuiInventoryGrid disableSlot(int index) {
        this.getSlot(index).setEnabled(false);
        return this;
    }

    public GuiInventoryGrid addListener(Consumer<GuiSlot> slot) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Consumer<GuiSlot>>();
        }
        this.listeners.add(slot);
        return this;
    }

    protected GuiControl addSlot(GuiSlot slot) {
        while (slot.slot.getContainerSlot() >= this.slots.size()) {
            this.slots.add(null);
        }
        this.slots.set(slot.slot.getContainerSlot(), slot);
        return super.add((GuiControl)slot);
    }

    @Override
    @Deprecated
    public GuiParent add(GuiControl control) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public GuiParent addHover(GuiControl control) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GuiSlot getSlot(int index) {
        return this.slots.get(index);
    }

    @Override
    public int inventorySize() {
        if (this.hasFixedSize) {
            return this.fixedSize;
        }
        return this.container.getContainerSize();
    }

    public boolean hasFixedSize() {
        return this.hasFixedSize;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void tick() {
        if (this.allChanged) {
            this.container.setChanged();
            this.syncAll();
            this.allChanged = false;
            this.changed.clear();
        } else if (!this.changed.isEmpty()) {
            this.container.setChanged();
            this.sync(this.changed);
            this.changed.clear();
        }
        super.tick();
    }

    @Override
    public void setChanged() {
        this.allChanged = true;
        if (this.listeners != null) {
            for (Consumer<GuiSlot> listener : this.listeners) {
                listener.accept(null);
            }
        }
    }

    @Override
    public void setChanged(int slotIndex) {
        if (this.allChanged) {
            return;
        }
        this.changed.set(slotIndex);
        GuiSlot slot = this.getSlot(slotIndex);
        if (this.listeners != null) {
            for (Consumer<GuiSlot> listener : this.listeners) {
                listener.accept(slot);
            }
        }
    }

    public static interface GuiInventoryGridDist
    extends GuiParent.GuiParentDistHandler {
        public void setGridDim(int var1, int var2);
    }
}

