/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import team.creative.creativecore.client.gui.registry.GuiClientRegistry;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiControlDistHandler;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.inventory.IGuiInventory;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.gui.manager.GuiManager;
import team.creative.creativecore.common.gui.manager.GuiManagerDist;
import team.creative.creativecore.common.gui.manager.GuiManagerItem;
import team.creative.creativecore.common.gui.sync.GuiSyncHolder;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.server.gui.registry.GuiServerRegistry;

public abstract class GuiLayer
extends GuiParent {
    public static final GuiLayerDistination CLIENT = new GuiLayerDistination(){

        @Override
        public boolean isClient() {
            return true;
        }

        @Override
        public <T extends GuiManagerDist> T createDist(GuiManager<T> manager) {
            return (T)((GuiManagerDist)((Object)GuiClientRegistry.create(manager)));
        }

        @Override
        public GuiControlDistHandler createDist(GuiControl control) {
            return GuiClientRegistry.create(control);
        }
    };
    public static final GuiLayerDistination SERVER = new GuiLayerDistination(){

        @Override
        public boolean isClient() {
            return false;
        }

        @Override
        public <T extends GuiManagerDist> T createDist(GuiManager<T> manager) {
            return (T)GuiServerRegistry.create(manager);
        }

        @Override
        public GuiControlDistHandler createDist(GuiControl control) {
            return GuiServerRegistry.create(control);
        }
    };
    private final GuiSyncHolder.GuiSyncHolderLayer sync = new GuiSyncHolder.GuiSyncHolderLayer(this);
    private HashMap<GuiManager.GuiManagerType, GuiManager> managers;

    protected static void collectInventories(Iterable<GuiControl> parent, List<IGuiInventory> inventories) {
        for (GuiControl control : parent) {
            if (control instanceof IGuiInventory) {
                IGuiInventory i = (IGuiInventory)((Object)control);
                inventories.add(i);
                continue;
            }
            if (!(control instanceof GuiParent)) continue;
            GuiParent p = (GuiParent)control;
            GuiLayer.collectInventories(p, inventories);
        }
    }

    public GuiLayer(boolean client, String name) {
        super(client ? CLIENT : SERVER, name, GuiFlow.STACK_X);
    }

    public GuiLayer(boolean client, String name, int width, int height) {
        super(client ? CLIENT : SERVER, name, GuiFlow.STACK_X);
        this.setDim(width, height);
    }

    @Override
    public GuiLayerDistHandler dist() {
        return (GuiLayerDistHandler)super.dist();
    }

    public void setParent(IGuiIntegratedParent parent) {
        GuiLayer.setParent(this, parent);
    }

    public Iterable<IGuiInventory> inventoriesToInsert() {
        ArrayList<IGuiInventory> inventories = new ArrayList<IGuiInventory>();
        GuiLayer.collectInventories(this, inventories);
        return inventories;
    }

    public Iterable<IGuiInventory> inventoriesToExract() {
        ArrayList<IGuiInventory> inventories = new ArrayList<IGuiInventory>();
        GuiLayer.collectInventories(this, inventories);
        Collections.reverse(inventories);
        return inventories;
    }

    public boolean has(GuiManager.GuiManagerType type) {
        if (this.managers == null) {
            return false;
        }
        return this.managers.containsKey(type);
    }

    public <T extends GuiManager> T getOrCreate(GuiManager.GuiManagerType<T> type) {
        GuiManager manager;
        if (this.managers == null) {
            this.managers = new HashMap();
        }
        if ((manager = this.managers.get(type)) == null) {
            manager = (GuiManager)type.factory().apply(this);
            this.managers.put(type, manager);
        }
        return (T)manager;
    }

    public GuiManagerItem itemManager() {
        return this.getOrCreate(GuiManager.ITEM);
    }

    public Iterable<GuiManager> managers() {
        if (this.managers == null) {
            return Collections.EMPTY_LIST;
        }
        return this.managers.values();
    }

    public GuiSyncHolder.GuiSyncHolderLayer getSyncHolder() {
        return this.sync;
    }

    @Override
    public void init() {
        this.create();
        super.init();
        this.reflow();
    }

    public void reinit() {
        super.init();
        this.reflow();
    }

    public abstract void create();

    public void becameTopLayer() {
    }

    @Override
    public GuiLayer getLayer() {
        return this;
    }

    public boolean closeLayerUsingEscape() {
        return true;
    }

    @Override
    public boolean hasLayer() {
        return true;
    }

    @Override
    public void tick() {
        for (GuiManager manager : this.managers()) {
            manager.tick();
        }
        super.tick();
    }

    @Override
    public void closed() {
        for (GuiManager manager : this.managers()) {
            manager.closed();
        }
        super.closed();
    }

    @Override
    public void reflow() {
        if (this.dist() != null) {
            this.dist().reflow();
        }
    }

    @Override
    public Rect toLayerRect(GuiControl control, Rect rect) {
        if (this.dist() != null) {
            this.dist().applyOffset(control, rect);
        }
        return rect;
    }

    public static abstract class GuiLayerDistination
    implements IGuiParent {
        @Override
        public boolean isContainer() {
            return false;
        }

        @Override
        public Player getPlayer() {
            return null;
        }

        @Override
        public void closeTopLayer() {
        }

        @Override
        public void closeLayer(GuiLayer layer) {
        }

        @Override
        public void raiseEvent(GuiEvent event) {
        }

        @Override
        public void reflow() {
        }

        @Override
        public boolean hasGui() {
            return false;
        }

        @Override
        public boolean isParent(IGuiParent parent) {
            return false;
        }

        @Override
        public Rect toScreenRect(GuiControl control, Rect rect) {
            return null;
        }

        @Override
        public Rect toLayerRect(GuiControl control, Rect rect) {
            return null;
        }

        @Override
        public IGuiIntegratedParent getIntegratedParent() {
            return null;
        }
    }

    public static interface GuiLayerDistHandler
    extends GuiParent.GuiParentDistHandler {
        public void reflow();
    }
}

