/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.gui.GuiControlDistHandler;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiSizeRule;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.ControlFormattingFlexible;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.mc.LanguageUtils;

public abstract class GuiControl {
    IGuiParent parent;
    private final GuiControlDistHandler dist;
    public final String name;

    public static void setParent(GuiLayer layer, IGuiIntegratedParent parent) {
        layer.parent = parent;
    }

    public static void setParent(GuiControl layer, IGuiParent parent) {
        layer.parent = parent;
    }

    public GuiControl(IGuiParent parent, String name) {
        this.parent = parent;
        this.dist = parent.createDist(this);
        this.name = name;
    }

    @Nullable
    public GuiControlDistHandler dist() {
        return this.dist;
    }

    public GuiControl setVisible(boolean visible) {
        if (this.dist != null) {
            this.dist.setVisible(visible);
        }
        return this;
    }

    public GuiControl setFixed() {
        if (this.dist != null) {
            this.dist.setFixed();
        }
        return this;
    }

    public GuiControl setFixedX() {
        if (this.dist != null) {
            this.dist.setFixedX();
        }
        return this;
    }

    public GuiControl setFixedY() {
        if (this.dist != null) {
            this.dist.setFixedY();
        }
        return this;
    }

    public GuiControl setExpandable() {
        if (this.dist != null) {
            this.dist.setExpandable();
        }
        return this;
    }

    public GuiControl setExpandableX() {
        if (this.dist != null) {
            this.dist.setExpandableX();
        }
        return this;
    }

    public GuiControl setExpandableY() {
        if (this.dist != null) {
            this.dist.setExpandableY();
        }
        return this;
    }

    public boolean isExpandableX() {
        if (this.dist != null) {
            return this.dist.isExpandableX();
        }
        return false;
    }

    public boolean isExpandableY() {
        if (this.dist != null) {
            return this.dist.isExpandableY();
        }
        return false;
    }

    public GuiControl setDim(int width, int height) {
        if (this.dist != null) {
            this.dist.setDim(width, height);
        }
        return this;
    }

    public GuiControl setDim(GuiSizeRule dim) {
        if (this.dist != null) {
            this.dist.setDim(dim);
        }
        return this;
    }

    public GuiControl setEnabled(boolean enabled) {
        if (this.dist != null) {
            this.dist.setEnabled(enabled);
        }
        return this;
    }

    public GuiControl removeFormatting() {
        if (this.dist != null) {
            this.dist.removeFormatting();
        }
        return this;
    }

    public GuiControl setFormatting(ControlFormatting formatting) {
        if (this.dist != null) {
            this.dist.setFormatting(formatting);
        }
        return this;
    }

    public ControlFormattingFlexible setCustomFormatting() {
        if (this.dist != null) {
            return this.dist.setCustomFormatting();
        }
        return new ControlFormattingFlexible.ControlFormattingFlexibleEmpty();
    }

    public void reflow() {
        if (this.getParent() != null) {
            this.getParent().reflow();
        }
    }

    public HolderLookup.Provider provider() {
        Player player = this.getPlayer();
        return player != null ? player.registryAccess() : null;
    }

    public boolean isClient() {
        if (this.parent != null) {
            return this.parent.isClient();
        }
        return CreativeCore.loader().getEffectiveSide().isClient();
    }

    public GuiControl setTooltip(List<Component> tooltip) {
        if (this.dist != null) {
            this.dist.setTooltip(tooltip);
        }
        return this;
    }

    public GuiControl setTooltip(String translate) {
        if (this.dist != null) {
            this.dist.setTooltip(translate);
        }
        return this;
    }

    public boolean hasGui() {
        if (this.parent != null) {
            return this.parent.hasGui();
        }
        return false;
    }

    public boolean isParent(IGuiParent parent) {
        if (this.parent == parent) {
            return true;
        }
        return this.parent.isParent(parent);
    }

    public IGuiParent getParent() {
        return this.parent;
    }

    public IGuiIntegratedParent getIntegratedParent() {
        return this.parent.getIntegratedParent();
    }

    public String getNestedName() {
        IGuiParent iGuiParent = this.getParent();
        if (iGuiParent instanceof GuiControl) {
            GuiControl control = (GuiControl)((Object)iGuiParent);
            return control.getNestedName() + "." + this.name;
        }
        return this.name;
    }

    public boolean hasLayer() {
        IGuiParent iGuiParent = this.parent;
        if (iGuiParent instanceof GuiControl) {
            GuiControl control = (GuiControl)((Object)iGuiParent);
            return control.hasLayer();
        }
        return false;
    }

    public GuiLayer getLayer() {
        IGuiParent iGuiParent = this.parent;
        if (iGuiParent instanceof GuiControl) {
            GuiControl control = (GuiControl)((Object)iGuiParent);
            return control.getLayer();
        }
        throw new RuntimeException("Invalid layer control");
    }

    public abstract void init();

    public abstract void closed();

    public abstract void tick();

    public boolean is(String name) {
        return this.name.equalsIgnoreCase(name);
    }

    public boolean is(String ... name) {
        for (String s : name) {
            if (!this.name.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public void raiseEvent(GuiEvent event) {
        if (this.parent != null) {
            this.parent.raiseEvent(event);
        }
    }

    public Player getPlayer() {
        return this.parent.getPlayer();
    }

    public Rect toLayerRect(Rect rect) {
        return this.getParent().toLayerRect(this, rect);
    }

    public Rect toScreenRect(Rect rect) {
        return this.getParent().toScreenRect(this, rect);
    }

    public static MutableComponent translatable(String text) {
        return Component.literal((String)GuiControl.translate(text));
    }

    public static MutableComponent translatable(String text, Object ... parameters) {
        return Component.literal((String)GuiControl.translate(text, parameters));
    }

    public static String translate(String text) {
        return LanguageUtils.translate(text);
    }

    public static String translate(String text, Object ... parameters) {
        return LanguageUtils.translate(text, parameters);
    }

    public static String translateOrDefault(String text, String defaultText) {
        return LanguageUtils.translateOr(text, defaultText);
    }

    public static interface GuiFocusControlDist
    extends GuiControlDistHandler {
        public boolean isFocused();

        public void focus();
    }
}

