/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.converation.registry;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.collection.GuiStackSelector;
import team.creative.creativecore.common.util.registry.FilteredHandlerRegistry;
import team.creative.creativecore.common.util.text.TextMapBuilder;

public abstract class GuiRegistryObjectHandler {
    public static final FilteredHandlerRegistry<Registry, GuiRegistryObjectHandler> REGISTRY = new FilteredHandlerRegistry(new GuiRegistryObjectHandler(){

        @Override
        public void createControls(GuiParent parent, Registry registry) {
            parent.add((GuiControl)new GuiComboBox<ResourceLocation>(parent, "elements", new TextMapBuilder<ResourceLocation>().addComponent(registry.keySet(), x -> {
                if (x.getNamespace().equals("minecraft")) {
                    return Component.literal((String)x.getPath());
                }
                return Component.literal((String)x.toString());
            })));
        }

        @Override
        public void loadValue(GuiParent parent, Registry registry, ResourceLocation location) {
            GuiComboBox box = (GuiComboBox)parent.get("elements");
            box.select(location);
        }

        @Override
        public ResourceLocation saveValue(GuiParent parent, Registry registry) {
            GuiComboBox box = (GuiComboBox)parent.get("elements");
            return (ResourceLocation)box.selected();
        }
    });

    public abstract void createControls(GuiParent var1, Registry var2);

    public abstract void loadValue(GuiParent var1, Registry var2, ResourceLocation var3);

    public abstract ResourceLocation saveValue(GuiParent var1, Registry var2);

    static {
        REGISTRY.register((Registry)BuiltInRegistries.BLOCK, new GuiRegistryObjectHandler(){

            @Override
            public void createControls(GuiParent parent, Registry registry) {
                parent.add((GuiControl)new GuiStackSelector(parent, "content", new GuiStackSelector.CreativeCollector(new GuiStackSelector.GuiBlockSelector())));
            }

            @Override
            public void loadValue(GuiParent parent, Registry registry, ResourceLocation location) {
                GuiStackSelector selector = (GuiStackSelector)parent.get("content");
                Block block = (Block)registry.getValue(location);
                selector.setSelectedForce(new ItemStack((ItemLike)block));
            }

            @Override
            public ResourceLocation saveValue(GuiParent parent, Registry registry) {
                GuiStackSelector selector = (GuiStackSelector)parent.get("content");
                Block block = Block.byItem((Item)selector.getSelected().getItem());
                return ((ResourceKey)block.builtInRegistryHolder().unwrapKey().get()).location();
            }
        });
    }
}

