/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix3x2fStack;
import team.creative.creativecore.CreativeCoreGuiRegistry;
import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.client.gui.GuiClientLayer;
import team.creative.creativecore.client.gui.control.inventory.GuiClientSlot;
import team.creative.creativecore.client.gui.manager.GuiClientManager;
import team.creative.creativecore.client.render.gui.CreativeGuiGraphics;
import team.creative.creativecore.common.gui.manager.GuiManagerItem;

public class GuiClientManagerItem
extends GuiClientManager<GuiManagerItem> {
    private boolean drag;
    private boolean rightClick;
    private List<GuiClientSlot> dragged;
    private List<Integer> stackSizes;

    public static int freeSpace(Slot slot, ItemStack hand) {
        if (slot.mayPlace(hand) && AbstractContainerMenu.canItemQuickReplace((Slot)slot, (ItemStack)hand, (boolean)true)) {
            int stackSize = slot.getMaxStackSize(hand);
            if (slot.hasItem()) {
                stackSize -= slot.getItem().getCount();
            }
            return stackSize;
        }
        return -1;
    }

    public GuiClientManagerItem(GuiManagerItem manager) {
        super(manager);
    }

    public ItemStack getHand() {
        return ((GuiManagerItem)this.manager).getHand();
    }

    public void setHandChanged() {
        ((GuiManagerItem)this.manager).setHandChanged();
    }

    @Override
    public void mouseClickedOutside(double x, double y) {
        if (!((GuiManagerItem)this.manager).getHand().isEmpty()) {
            CreativeCoreGuiRegistry.DROP_HAND.send(((GuiManagerItem)this.manager).layer, EndTag.INSTANCE);
        }
    }

    @Override
    public void mouseReleased(double x, double y, MouseButtonInfo info) {
        if (this.isDragged() && this.rightClick == (info.button() == 1)) {
            this.endDrag();
        }
    }

    @Override
    public void renderOverlay(GuiGraphics graphics, GuiClientLayer layer, int mouseX, int mouseY) {
        ItemStack stack = ((GuiManagerItem)this.manager).getHand();
        int count = stack.getCount();
        if (this.drag) {
            int used = 0;
            int countPerSlot = Math.max(1, Mth.floor((float)((float)((GuiManagerItem)this.manager).getHand().getCount() / (float)this.stackSizes.size())));
            if (this.rightClick) {
                countPerSlot = 1;
            }
            for (int i = 0; i < this.stackSizes.size(); ++i) {
                used += Math.min(countPerSlot, this.stackSizes.get(i));
            }
            int left = ((GuiManagerItem)this.manager).getHand().getCount() - used;
            count = Math.max(0, left);
        }
        if (!(stack.isEmpty() || this.drag && !this.rightClick && this.dragged.size() <= 1)) {
            Matrix3x2fStack pose = graphics.pose();
            pose.pushMatrix();
            GuiClientControl.scissor(graphics, null);
            pose.translate((float)(mouseX - 8), (float)(mouseY - 8));
            graphics.renderItem(stack, 0, 0);
            ((CreativeGuiGraphics)graphics).renderItemDecorations(stack, 0, 0, count == 1 ? null : "" + count);
            pose.popMatrix();
        }
    }

    public void startDrag(GuiClientSlot slot, boolean rightClick, int stackSize) {
        this.drag = true;
        this.dragged = new ArrayList<GuiClientSlot>();
        this.dragged.add(slot);
        this.rightClick = rightClick;
        this.stackSizes = new ArrayList<Integer>();
        this.stackSizes.add(stackSize);
        slot.draggedIndex = 0;
    }

    public void addToDrag(GuiClientSlot slot) {
        int stackSize = GuiClientManagerItem.freeSpace(slot.slot(), ((GuiManagerItem)this.manager).getHand());
        if (stackSize > 0) {
            slot.draggedIndex = this.dragged.size();
            this.dragged.add(slot);
            this.stackSizes.add(stackSize);
        }
    }

    public void modifyDrag(GuiClientSlot slot) {
        this.stackSizes.set(slot.draggedIndex, GuiClientManagerItem.freeSpace(slot.slot(), ((GuiManagerItem)this.manager).getHand()));
    }

    public void abortDrag() {
        for (GuiClientSlot slot : this.dragged) {
            slot.draggedIndex = -1;
        }
        this.drag = false;
        this.rightClick = false;
        this.dragged = null;
        this.stackSizes = null;
    }

    public void endDrag() {
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean("rightClick", this.rightClick);
        HashMap<String, Integer> inventories = new HashMap<String, Integer>();
        ListTag names = new ListTag();
        int[] ids = new int[this.dragged.size() * 2];
        int i = 0;
        for (GuiClientSlot slot : this.dragged) {
            String inventory = slot.inventory().name();
            Integer inventoryId = (Integer)inventories.get(inventory);
            if (inventoryId == null) {
                inventoryId = inventories.size();
                inventories.put(inventory, inventoryId);
                names.add((Object)StringTag.valueOf((String)inventory));
            }
            ids[i] = inventoryId;
            ids[i + 1] = slot.slot().getContainerSlot();
            i += 2;
        }
        nbt.putIntArray("ids", ids);
        nbt.put("names", (Tag)names);
        CreativeCoreGuiRegistry.SPREAD.sendAndExecute(((GuiManagerItem)this.manager).layer, nbt);
        if (this.isDragged()) {
            this.abortDrag();
        }
    }

    public boolean isDragged() {
        return this.drag;
    }

    public void setHand(ItemStack stack) {
        ((GuiManagerItem)this.manager).setHand(stack);
    }

    public int additionalDragCount(int index) {
        if (index >= ((GuiManagerItem)this.manager).getHand().getCount()) {
            return 0;
        }
        if (this.rightClick) {
            return 1;
        }
        return Math.max(1, Mth.floor((float)((float)((GuiManagerItem)this.manager).getHand().getCount() / (float)this.dragged.size())));
    }
}

