/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.simple;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3x2fStack;
import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.client.render.gui.CreativeGuiGraphics;
import team.creative.creativecore.common.gui.control.simple.GuiIcon;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.Icon;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.type.Color;

public class GuiClientIcon<T extends GuiIcon>
extends GuiClientControl<T>
implements GuiIcon.GuiIconDist {
    protected Icon icon;
    protected Color shadow = Color.NONE;
    protected Color color = Color.WHITE;
    protected boolean squared;

    public GuiClientIcon(T control) {
        super(control);
    }

    @Override
    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void setShadow(Color shadowColor) {
        this.shadow = shadowColor;
    }

    @Override
    public void setSquared(boolean squared) {
        this.squared = squared;
    }

    @Override
    public void flowX(int width, int preferred) {
    }

    @Override
    public void flowY(int width, int height, int preferred) {
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return 12;
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return 12;
    }

    @Override
    public StyleDisplay getBackground(GuiStyle style, StyleDisplay display) {
        return StyleDisplay.NONE;
    }

    @Override
    protected void renderContent(GuiGraphics graphics, int mouseX, int mouseY) {
        Matrix3x2fStack pose = graphics.pose();
        pose.pushMatrix();
        ResourceLocation location = this.icon.location();
        int x = 0;
        int y = 0;
        int width = this.rect.getContentWidth();
        int height = this.rect.getContentHeight();
        if (this.squared) {
            int size = Math.min(width, height);
            int diff = Math.abs(width - height);
            if (width == size) {
                y += diff / 2;
            } else {
                x += diff / 2;
            }
            width = height = size;
        }
        if (this.shadow != Color.NONE) {
            ((CreativeGuiGraphics)graphics).textureRectColor(location, x + 1, y + 1, width, height, this.icon.minX(), this.icon.minY(), this.icon.minX() + this.icon.width(), this.icon.minY() + this.icon.height(), this.shadow.toInt());
        }
        ((CreativeGuiGraphics)graphics).textureRectColor(location, x, y, width, height, this.icon.minX(), this.icon.minY(), this.icon.minX() + this.icon.width(), this.icon.minY() + this.icon.height(), this.color.toInt());
        pose.popMatrix();
    }

    @Override
    protected ControlFormatting defaultFormatting() {
        return ControlFormatting.TRANSPARENT_NO_DISABLE;
    }
}

