/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.inventory;

import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.client.gui.GuiClientParent;
import team.creative.creativecore.common.gui.control.inventory.GuiInventoryGrid;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiClientInventoryGrid<T extends GuiInventoryGrid>
extends GuiClientParent<T>
implements GuiInventoryGrid.GuiInventoryGridDist {
    protected boolean reverse = false;
    private int cols;
    private int rows;
    private int cachedCols;
    private int cachedRows;

    public GuiClientInventoryGrid(T control) {
        super(control);
    }

    @Override
    public void setGridDim(int cols, int rows) {
        this.cols = cols;
        this.rows = rows;
    }

    @Override
    protected int minWidth(int availableWidth) {
        return ((GuiInventoryGrid)this.control).hasFixedSize() ? this.cols * 18 : 18;
    }

    @Override
    protected int minHeight(int width, int availableHeight) {
        return ((GuiInventoryGrid)this.control).hasFixedSize() ? this.rows * 18 : 18;
    }

    @Override
    public void flowX(int width, int preferred) {
        this.cachedCols = width / 18;
        if (((GuiInventoryGrid)this.control).hasFixedSize()) {
            this.cachedCols = Math.min(this.cachedCols, this.cols);
        }
        int offset = (width - this.cachedCols * 18) / 2;
        int i = 0;
        for (GuiClientControl control : this.controls()) {
            control.rect.setX(offset + i % this.cachedCols * 18);
            control.rect.setWidth(18, width);
            control.rect.flowX();
            ++i;
        }
    }

    @Override
    public void flowY(int witdh, int height, int preferred) {
        this.cachedRows = height / 18;
        if (((GuiInventoryGrid)this.control).hasFixedSize()) {
            this.cachedRows = Math.min(this.cachedRows, this.rows);
        }
        int offset = (height - this.cachedRows * 18) / 2;
        int i = this.reverse ? ((GuiInventoryGrid)this.control).size() - 1 : 0;
        for (GuiClientControl control : this.controls()) {
            int row = i / this.cachedCols;
            control.rect.setY(offset + row * 18);
            control.rect.setHeight(18, height);
            control.rect.flowY();
            boolean bl = control.visible = row <= this.cachedRows;
            if (this.reverse) {
                --i;
                continue;
            }
            ++i;
        }
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return this.cols * 18;
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return (int)Math.ceil((double)((GuiInventoryGrid)this.control).container.getContainerSize() / (double)this.cachedCols) * 18;
    }

    @Override
    protected ControlFormatting defaultFormatting() {
        return ControlFormatting.TRANSPARENT;
    }
}

