/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.uniforms;

import net.caffeinemc.mods.sodium.client.util.FogStorage;
import net.irisshaders.iris.gl.state.FogMode;
import net.irisshaders.iris.gl.state.StateUpdateNotifiers;
import net.irisshaders.iris.gl.uniform.DynamicUniformHolder;
import net.irisshaders.iris.gl.uniform.UniformUpdateFrequency;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.minecraft.client.Minecraft;
import org.joml.Vector3f;

public class FogUniforms {
    private FogUniforms() {
    }

    public static void addFogUniforms(DynamicUniformHolder uniforms, FogMode fogMode) {
        if (fogMode == FogMode.OFF) {
            uniforms.uniform1i(UniformUpdateFrequency.ONCE, "fogMode", () -> 0);
            uniforms.uniform1i(UniformUpdateFrequency.ONCE, "fogShape", () -> -1);
        } else if (fogMode == FogMode.PER_VERTEX || fogMode == FogMode.PER_FRAGMENT) {
            uniforms.uniform1i("fogMode", () -> {
                float fogDensity = CapturedRenderingState.INSTANCE.getFogDensity();
                if (fogDensity < 0.0f) {
                    return 9729;
                }
                return 2049;
            }, listener -> {});
            uniforms.uniform1i(UniformUpdateFrequency.PER_FRAME, "fogShape", () -> 1);
        }
        uniforms.uniform1f("fogDensity", () -> Math.max(0.0f, CapturedRenderingState.INSTANCE.getFogDensity()), notifier -> {});
        uniforms.uniform1f("fogStart", () -> ((FogStorage)Minecraft.getInstance().gameRenderer).sodium$getFogParameters().environmentalStart(), listener -> StateUpdateNotifiers.fogStartNotifier.setListener(listener));
        uniforms.uniform1f("fogEnd", () -> ((FogStorage)Minecraft.getInstance().gameRenderer).sodium$getFogParameters().environmentalEnd(), listener -> StateUpdateNotifiers.fogEndNotifier.setListener(listener));
        uniforms.uniform3f(UniformUpdateFrequency.PER_FRAME, "fogColor", () -> new Vector3f((float)CapturedRenderingState.INSTANCE.getFogColor().x, (float)CapturedRenderingState.INSTANCE.getFogColor().y, (float)CapturedRenderingState.INSTANCE.getFogColor().z));
    }
}

