/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.platform;

import com.mojang.blaze3d.textures.TextureFormat;
import java.nio.file.Path;
import net.irisshaders.iris.gl.texture.DepthBufferFormat;
import net.irisshaders.iris.platform.IrisForgeMod;
import net.irisshaders.iris.platform.IrisPlatformHelpers;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class IrisForgeHelpers
implements IrisPlatformHelpers {
    boolean HAS_CAMO = this.isModLoaded("cable_facades");

    @Override
    public boolean isModLoaded(String modId) {
        return FMLLoader.getCurrent().getLoadingModList().getModFileById(modId) != null;
    }

    @Override
    public String getVersion() {
        return FMLLoader.getCurrent().getLoadingModList().getModFileById("iris").versionString();
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.getCurrent().isProduction();
    }

    @Override
    public Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public int compareVersions(String currentVersion, String semanticVersion) throws Exception {
        return new DefaultArtifactVersion(currentVersion).compareTo((ArtifactVersion)new DefaultArtifactVersion(semanticVersion));
    }

    @Override
    public KeyMapping registerKeyBinding(KeyMapping keyMapping) {
        IrisForgeMod.KEYLIST.add(keyMapping);
        return keyMapping;
    }

    @Override
    public boolean useELS() {
        return true;
    }

    @Override
    public BlockState getBlockAppearance(BlockAndTintGetter level, BlockState state, Direction cullFace, BlockPos pos) {
        return state;
    }

    @Override
    public TextureFormat mojangDepthFormat(DepthBufferFormat depthFormat) {
        return switch (depthFormat) {
            default -> throw new MatchException(null, null);
            case DepthBufferFormat.DEPTH -> TextureFormat.DEPTH32;
            case DepthBufferFormat.DEPTH16 -> null;
            case DepthBufferFormat.DEPTH24 -> null;
            case DepthBufferFormat.DEPTH32 -> TextureFormat.DEPTH32;
            case DepthBufferFormat.DEPTH32F -> null;
            case DepthBufferFormat.DEPTH_STENCIL -> TextureFormat.DEPTH24_STENCIL8;
            case DepthBufferFormat.DEPTH24_STENCIL8 -> TextureFormat.DEPTH24_STENCIL8;
            case DepthBufferFormat.DEPTH32F_STENCIL8 -> TextureFormat.DEPTH32_STENCIL8;
        };
    }
}

