/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pipeline.programs;

import com.mojang.blaze3d.opengl.GlProgram;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.shaders.UniformType;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.ArrayList;
import net.irisshaders.iris.compat.SkipList;
import net.irisshaders.iris.gl.blending.BlendModeOverride;
import net.irisshaders.iris.gl.blending.DepthColorStorage;
import net.irisshaders.iris.gl.framebuffer.GlFramebuffer;
import net.irisshaders.iris.mixinterface.ShaderInstanceInterface;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.IrisProgram;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import org.lwjgl.opengl.GL31C;
import org.lwjgl.opengl.GL46C;

public class FallbackShader
extends GlProgram
implements IrisProgram {
    private final IrisRenderingPipeline parent;
    private final BlendModeOverride blendModeOverride;
    private final GlFramebuffer writingToBeforeTranslucent;
    private final GlFramebuffer writingToAfterTranslucent;
    private final int FOG_DENSITY;
    private final int FOG_IS_EXP2;
    private final int gtexture;
    private final int overlay;
    private final int lightmap;
    private boolean isSetUp;

    public FallbackShader(int programId, RenderPipeline pipeline, String string, VertexFormat vertexFormat, GlFramebuffer writingToBeforeTranslucent, GlFramebuffer writingToAfterTranslucent, BlendModeOverride blendModeOverride, float alphaValue, IrisRenderingPipeline parent) throws IOException {
        super(programId, string);
        ((ShaderInstanceInterface)((Object)this)).setShouldSkip(SkipList.NONE);
        ArrayList<RenderPipeline.UniformDescription> uniforms = new ArrayList<RenderPipeline.UniformDescription>(pipeline.getUniforms());
        uniforms.add(new RenderPipeline.UniformDescription("DynamicTransforms", UniformType.UNIFORM_BUFFER));
        uniforms.add(new RenderPipeline.UniformDescription("CloudInfo", UniformType.UNIFORM_BUFFER));
        uniforms.add(new RenderPipeline.UniformDescription("Projection", UniformType.UNIFORM_BUFFER));
        uniforms.add(new RenderPipeline.UniformDescription("Fog", UniformType.UNIFORM_BUFFER));
        uniforms.add(new RenderPipeline.UniformDescription("Globals", UniformType.UNIFORM_BUFFER));
        uniforms.add(new RenderPipeline.UniformDescription("Lighting", UniformType.UNIFORM_BUFFER));
        this.setupUniforms(uniforms, pipeline.getSamplers());
        this.parent = parent;
        this.blendModeOverride = blendModeOverride;
        this.writingToBeforeTranslucent = writingToBeforeTranslucent;
        this.writingToAfterTranslucent = writingToAfterTranslucent;
        this.FOG_DENSITY = GlStateManager._glGetUniformLocation((int)programId, (CharSequence)"FogDensity");
        this.FOG_IS_EXP2 = GlStateManager._glGetUniformLocation((int)programId, (CharSequence)"FogIsExp2");
        this.gtexture = GlStateManager._glGetUniformLocation((int)programId, (CharSequence)"gtexture");
        this.overlay = GlStateManager._glGetUniformLocation((int)programId, (CharSequence)"overlay");
        this.lightmap = GlStateManager._glGetUniformLocation((int)programId, (CharSequence)"lightmap");
        GlStateManager._glUseProgram((int)programId);
        int ALPHA_TEST_VALUE = GlStateManager._glGetUniformLocation((int)programId, (CharSequence)"AlphaTestValue");
        if (ALPHA_TEST_VALUE > -1) {
            GL46C.glUniform1f((int)ALPHA_TEST_VALUE, (float)alphaValue);
        }
    }

    @Override
    public void iris$clearState() {
        if (this.blendModeOverride != null) {
            BlendModeOverride.restore();
        }
        this.isSetUp = false;
    }

    @Override
    public int iris$getBlockIndex(int program, CharSequence uniformBlockName) {
        return GL31C.glGetUniformBlockIndex((int)program, (CharSequence)uniformBlockName);
    }

    @Override
    public boolean iris$isSetUp() {
        return this.isSetUp;
    }

    @Override
    public void iris$setupState() {
        this.isSetUp = true;
        DepthColorStorage.unlockDepthColor();
        GlStateManager._glUseProgram((int)this.getProgramId());
        if (this.FOG_DENSITY > -1 && this.FOG_IS_EXP2 > -1) {
            float fogDensity = CapturedRenderingState.INSTANCE.getFogDensity();
            if ((double)fogDensity >= 0.0) {
                GL46C.glUniform1f((int)this.FOG_DENSITY, (float)fogDensity);
                GL46C.glUniform1i((int)this.FOG_IS_EXP2, (int)1);
            } else {
                GL46C.glUniform1f((int)this.FOG_DENSITY, (float)0.0f);
                GL46C.glUniform1i((int)this.FOG_IS_EXP2, (int)0);
            }
        }
        GlStateManager._glUniform1i((int)this.gtexture, (int)0);
        GlStateManager._glUniform1i((int)this.overlay, (int)1);
        GlStateManager._glUniform1i((int)this.lightmap, (int)2);
        if (this.blendModeOverride != null) {
            this.blendModeOverride.apply();
        }
        if (this.parent.isBeforeTranslucent) {
            this.writingToBeforeTranslucent.bind();
        } else {
            this.writingToAfterTranslucent.bind();
        }
    }
}

