/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pipeline.programs;

import com.mojang.blaze3d.opengl.GlProgram;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.Uniform;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.shaders.UniformType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.irisshaders.iris.compat.SkipList;
import net.irisshaders.iris.gl.GLDebug;
import net.irisshaders.iris.gl.IrisRenderSystem;
import net.irisshaders.iris.gl.blending.AlphaTest;
import net.irisshaders.iris.gl.blending.BlendModeOverride;
import net.irisshaders.iris.gl.blending.BufferBlendOverride;
import net.irisshaders.iris.gl.blending.DepthColorStorage;
import net.irisshaders.iris.gl.framebuffer.GlFramebuffer;
import net.irisshaders.iris.gl.image.ImageHolder;
import net.irisshaders.iris.gl.program.ProgramImages;
import net.irisshaders.iris.gl.program.ProgramSamplers;
import net.irisshaders.iris.gl.program.ProgramUniforms;
import net.irisshaders.iris.gl.sampler.SamplerHolder;
import net.irisshaders.iris.gl.texture.TextureType;
import net.irisshaders.iris.gl.uniform.DynamicLocationalUniformHolder;
import net.irisshaders.iris.mixinterface.ShaderInstanceInterface;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.IrisProgram;
import net.irisshaders.iris.samplers.IrisSamplers;
import net.irisshaders.iris.shadows.ShadowRenderer;
import net.irisshaders.iris.shadows.ShadowRenderingState;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.irisshaders.iris.uniforms.custom.CustomUniforms;
import net.irisshaders.iris.vertices.ImmediateState;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL46C;
import org.slf4j.Logger;

public class ExtendedShader
extends GlProgram
implements IrisProgram {
    private static final Matrix4f identity;
    private static final Logger LOGGER;
    private static ExtendedShader lastApplied;
    private final boolean intensitySwizzle;
    private final List<BufferBlendOverride> bufferBlendOverrides;
    private final boolean hasOverrides;
    private final int modelViewInverse;
    private final int projectionInverse;
    private final Matrix3f normalMatrix = new Matrix3f();
    private final CustomUniforms customUniforms;
    private final IrisRenderingPipeline parent;
    private final ProgramUniforms uniforms;
    private final ProgramSamplers samplers;
    private final ProgramImages images;
    private final GlFramebuffer writingToBeforeTranslucent;
    private final GlFramebuffer writingToAfterTranslucent;
    private final BlendModeOverride blendModeOverride;
    private final float alphaTest;
    private final boolean usesTessellation;
    private final Matrix4f tempMatrix4f = new Matrix4f();
    private final Matrix3f tempMatrix3f = new Matrix3f();
    private final float[] tempFloats = new float[16];
    private final float[] tempFloats2 = new float[9];
    private final int normalMat;
    private boolean hasUV;
    private int textureToUnswizzle;
    private boolean isSetup;
    private final IrisRenderingPipeline pipeline;
    private float[] tempF = new float[9];

    public ExtendedShader(int programId, String string, VertexFormat vertexFormat, boolean usesTessellation, GlFramebuffer writingToBeforeTranslucent, GlFramebuffer writingToAfterTranslucent, BlendModeOverride blendModeOverride, AlphaTest alphaTest, Consumer<DynamicLocationalUniformHolder> uniformCreator, BiConsumer<SamplerHolder, ImageHolder> samplerCreator, boolean isIntensity, IrisRenderingPipeline parent, @Nullable List<BufferBlendOverride> bufferBlendOverrides, CustomUniforms customUniforms) throws IOException {
        super(programId, string);
        this.pipeline = parent;
        GLDebug.nameObject(33506, programId, string);
        ((ShaderInstanceInterface)((Object)this)).setShouldSkip(SkipList.NONE);
        ArrayList<RenderPipeline.UniformDescription> uniformList = new ArrayList<RenderPipeline.UniformDescription>();
        ArrayList<String> samplerList = new ArrayList<String>();
        uniformList.add(new RenderPipeline.UniformDescription("DynamicTransforms", UniformType.UNIFORM_BUFFER));
        uniformList.add(new RenderPipeline.UniformDescription("CloudInfo", UniformType.UNIFORM_BUFFER));
        uniformList.add(new RenderPipeline.UniformDescription("CloudFaces", UniformType.TEXEL_BUFFER, TextureFormat.RED8I));
        uniformList.add(new RenderPipeline.UniformDescription("Projection", UniformType.UNIFORM_BUFFER));
        uniformList.add(new RenderPipeline.UniformDescription("Fog", UniformType.UNIFORM_BUFFER));
        uniformList.add(new RenderPipeline.UniformDescription("Globals", UniformType.UNIFORM_BUFFER));
        if (vertexFormat.contains(VertexFormatElement.UV)) {
            this.hasUV = true;
            samplerList.add("Sampler0");
        }
        if (vertexFormat.contains(VertexFormatElement.UV1)) {
            samplerList.add("Sampler1");
        }
        if (vertexFormat.contains(VertexFormatElement.UV2)) {
            samplerList.add("Sampler2");
        }
        super.setupUniforms(uniformList, samplerList);
        ProgramUniforms.Builder uniformBuilder = ProgramUniforms.builder(string, programId);
        ProgramSamplers.Builder samplerBuilder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
        uniformCreator.accept(uniformBuilder);
        this.normalMat = GlStateManager._glGetUniformLocation((int)programId, (CharSequence)"iris_NormalMat");
        ProgramImages.Builder builder = ProgramImages.builder(programId);
        samplerCreator.accept(samplerBuilder, builder);
        customUniforms.mapholderToPass(uniformBuilder, this);
        this.usesTessellation = usesTessellation;
        this.uniforms = uniformBuilder.buildUniforms();
        this.customUniforms = customUniforms;
        this.samplers = samplerBuilder.build();
        this.images = builder.build();
        this.writingToBeforeTranslucent = writingToBeforeTranslucent;
        this.writingToAfterTranslucent = writingToAfterTranslucent;
        this.blendModeOverride = blendModeOverride;
        this.bufferBlendOverrides = bufferBlendOverrides;
        this.hasOverrides = bufferBlendOverrides != null && !bufferBlendOverrides.isEmpty();
        this.alphaTest = alphaTest.reference();
        this.parent = parent;
        this.modelViewInverse = GlStateManager._glGetUniformLocation((int)programId, (CharSequence)"iris_ModelViewMatInverse");
        this.projectionInverse = GlStateManager._glGetUniformLocation((int)programId, (CharSequence)"iris_ProjMatInverse");
        this.intensitySwizzle = isIntensity;
    }

    public boolean isIntensitySwizzle() {
        return this.intensitySwizzle;
    }

    @Override
    public void iris$clearState() {
        ProgramUniforms.clearActiveUniforms();
        ProgramSamplers.clearActiveSamplers();
        if (this.blendModeOverride != null || this.hasOverrides) {
            BlendModeOverride.restore();
        }
        this.isSetup = false;
    }

    @Override
    public void iris$setupState() {
        this.isSetup = true;
        DepthColorStorage.unlockDepthColor();
        if (!this.hasUV) {
            IrisRenderSystem.bindTextureToUnit(3553, 0, this.pipeline.getWhitePixel().getTexture().iris$getGlId());
        }
        CapturedRenderingState.INSTANCE.setCurrentAlphaTest(this.alphaTest);
        GlStateManager._glUseProgram((int)this.getProgramId());
        if (this.modelViewInverse > -1) {
            IrisRenderSystem.uniformMatrix4fv(this.modelViewInverse, false, RenderSystem.getModelViewMatrix().invert(this.tempMatrix4f).get(this.tempFloats));
        }
        if (this.normalMat > -1) {
            this.tempF = RenderSystem.getModelViewMatrix().invert(this.tempMatrix4f).transpose3x3(this.normalMatrix).get(this.tempF);
            IrisRenderSystem.uniformMatrix3fv(this.normalMat, false, this.tempF);
        }
        if (this.projectionInverse > -1) {
            IrisRenderSystem.uniformMatrix4fv(this.projectionInverse, false, (ShadowRenderingState.areShadowsCurrentlyBeingRendered() ? ShadowRenderer.PROJECTION : CapturedRenderingState.INSTANCE.getGbufferProjection()).invert(this.tempMatrix4f).get(this.tempFloats));
        }
        if (this.intensitySwizzle) {
            IrisRenderSystem.addUnswizzle(RenderSystem.getShaderTexture((int)0).texture().iris$getGlId());
            IrisRenderSystem.texParameteriv(RenderSystem.getShaderTexture((int)0).texture().iris$getGlId(), TextureType.TEXTURE_2D.getGlType(), 36422, new int[]{6403, 6403, 6403, 6403});
        }
        ImmediateState.usingTessellation = this.usesTessellation;
        this.samplers.update();
        this.uniforms.update();
        this.customUniforms.push(this);
        this.images.update();
        BlendModeOverride.restore();
        if (this.blendModeOverride != null) {
            this.blendModeOverride.apply();
        }
        if (this.hasOverrides) {
            this.bufferBlendOverrides.forEach(BufferBlendOverride::apply);
        }
        if (this.parent.isBeforeTranslucent) {
            this.writingToBeforeTranslucent.bind();
        } else {
            this.writingToAfterTranslucent.bind();
        }
    }

    public Map<String, Uniform> getUniforms() {
        return super.getUniforms();
    }

    public boolean hasActiveImages() {
        return this.images.getActiveImages() > 0;
    }

    @Override
    public int iris$getBlockIndex(int program, CharSequence uniformBlockName) {
        return GL46C.glGetUniformBlockIndex((int)program, (CharSequence)("iris_" + String.valueOf(uniformBlockName)));
    }

    @Override
    public boolean iris$isSetUp() {
        return this.isSetup;
    }

    static {
        LOGGER = LogUtils.getLogger();
        identity = new Matrix4f();
        identity.identity();
    }
}

