/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pathways;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderPipelines;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class HorizonRenderer {
    private static final float TOP = 16.0f;
    private static final float BOTTOM = -16.0f;
    private static final float COS_22_5 = (float)Math.cos(Math.toRadians(22.5));
    private static final float SIN_22_5 = (float)Math.sin(Math.toRadians(22.5));
    private GpuBuffer buffer;
    private int currentRenderDistance;
    private int indexCount = -1;

    public HorizonRenderer() {
        this.currentRenderDistance = Minecraft.getInstance().options.getEffectiveRenderDistance();
        this.rebuildBuffer();
    }

    private void rebuildBuffer() {
        if (this.buffer != null) {
            this.buffer.close();
        }
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        this.buildHorizon(this.currentRenderDistance * 16, (VertexConsumer)buffer);
        MeshData meshData = buffer.build();
        this.buffer = RenderSystem.getDevice().createBuffer(() -> "Horizon", 40, meshData.vertexBuffer());
        this.indexCount = meshData.drawState().indexCount();
        meshData.close();
        Tesselator.getInstance().clear();
    }

    private void buildQuad(VertexConsumer consumer, float x1, float z1, float x2, float z2) {
        consumer.addVertex(x1, -16.0f, z1);
        consumer.addVertex(x1, 16.0f, z1);
        consumer.addVertex(x2, 16.0f, z2);
        consumer.addVertex(x2, -16.0f, z2);
    }

    private void buildHalf(VertexConsumer consumer, float adjacent, float opposite, boolean invert) {
        if (invert) {
            adjacent = -adjacent;
            opposite = -opposite;
        }
        this.buildQuad(consumer, adjacent, -opposite, opposite, -adjacent);
        this.buildQuad(consumer, adjacent, opposite, adjacent, -opposite);
        this.buildQuad(consumer, opposite, adjacent, adjacent, opposite);
        this.buildQuad(consumer, -opposite, adjacent, opposite, adjacent);
    }

    private void buildOctagonalPrism(VertexConsumer consumer, float adjacent, float opposite) {
        this.buildHalf(consumer, adjacent, opposite, false);
        this.buildHalf(consumer, adjacent, opposite, true);
    }

    private void buildRegularOctagonalPrism(VertexConsumer consumer, float radius) {
        this.buildOctagonalPrism(consumer, radius * COS_22_5, radius * SIN_22_5);
    }

    private void buildBottomPlane(VertexConsumer consumer, int radius) {
        for (int x = -radius; x <= radius; x += 64) {
            for (int z = -radius; z <= radius; z += 64) {
                consumer.addVertex((float)(x + 64), -16.0f, (float)z);
                consumer.addVertex((float)x, -16.0f, (float)z);
                consumer.addVertex((float)x, -16.0f, (float)(z + 64));
                consumer.addVertex((float)(x + 64), -16.0f, (float)(z + 64));
            }
        }
    }

    private void buildTopPlane(VertexConsumer consumer, int radius) {
        for (int x = -radius; x <= radius; x += 64) {
            for (int z = -radius; z <= radius; z += 64) {
                consumer.addVertex((float)(x + 64), 16.0f, (float)z);
                consumer.addVertex((float)(x + 64), 16.0f, (float)(z + 64));
                consumer.addVertex((float)x, 16.0f, (float)(z + 64));
                consumer.addVertex((float)x, 16.0f, (float)z);
            }
        }
    }

    private void buildHorizon(int radius, VertexConsumer consumer) {
        if (radius > 256) {
            radius = 256;
        }
        this.buildRegularOctagonalPrism(consumer, radius);
        this.buildTopPlane(consumer, 384);
        this.buildBottomPlane(consumer, 384);
    }

    public void renderHorizon(Matrix4fc modelView, Matrix4fc projection, Vector4f fogColor) {
        if (this.currentRenderDistance != Minecraft.getInstance().options.getEffectiveRenderDistance()) {
            this.currentRenderDistance = Minecraft.getInstance().options.getEffectiveRenderDistance();
            this.rebuildBuffer();
        }
        RenderSystem.AutoStorageIndexBuffer indices = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS);
        GpuBuffer indexBuffer = indices.getBuffer(this.indexCount);
        GpuBufferSlice gpuBufferSlice = RenderSystem.getDynamicUniforms().writeTransform(modelView, (Vector4fc)fogColor, (Vector3fc)new Vector3f(), (Matrix4fc)RenderSystem.getTextureMatrix(), RenderSystem.getShaderLineWidth());
        try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Sky", Minecraft.getInstance().getMainRenderTarget().getColorTextureView(), OptionalInt.empty(), Minecraft.getInstance().getMainRenderTarget().getDepthTextureView(), OptionalDouble.empty());){
            RenderSystem.bindDefaultUniforms((RenderPass)pass);
            pass.setUniform("DynamicTransforms", gpuBufferSlice);
            for (int i = 0; i < 12; ++i) {
                GpuTextureView gpuTextureView3 = RenderSystem.getShaderTexture((int)i);
                if (gpuTextureView3 == null) continue;
                pass.bindSampler("Sampler" + i, gpuTextureView3);
            }
            pass.setVertexBuffer(0, this.buffer);
            pass.setIndexBuffer(indexBuffer, indices.type());
            pass.setPipeline(RenderPipelines.SKY);
            pass.drawIndexed(0, 0, this.indexCount, 1);
        }
    }

    public void destroy() {
        this.buffer.close();
    }
}

