/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.layer;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import java.util.Optional;
import net.irisshaders.iris.mixin.rendertype.RenderTypeAccessor;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.Nullable;

public class OuterWrappedRenderType
extends RenderType {
    private final RenderStateShard extra;
    private final RenderType wrapped;

    public OuterWrappedRenderType(String name, RenderType wrapped, RenderStateShard extra) {
        super(name, wrapped.bufferSize(), wrapped.affectsCrumbling(), OuterWrappedRenderType.shouldSortOnUpload(wrapped), () -> ((RenderType)wrapped).setupRenderState(), () -> ((RenderType)wrapped).clearRenderState());
        this.extra = extra;
        this.wrapped = wrapped;
    }

    public static OuterWrappedRenderType wrapExactlyOnce(String name, RenderType wrapped, RenderStateShard extra) {
        while (wrapped instanceof OuterWrappedRenderType) {
            wrapped = ((OuterWrappedRenderType)wrapped).unwrap();
        }
        return new OuterWrappedRenderType(name, wrapped, extra);
    }

    private RenderType unwrap() {
        return this.wrapped;
    }

    private static boolean shouldSortOnUpload(RenderType type) {
        return ((RenderTypeAccessor)type).shouldSortOnUpload();
    }

    public void setupRenderState() {
        this.extra.setupRenderState();
        super.setupRenderState();
    }

    public void clearRenderState() {
        super.clearRenderState();
        this.extra.clearRenderState();
    }

    public Optional<RenderType> outline() {
        return this.wrapped.outline();
    }

    public boolean isOutline() {
        return this.wrapped.isOutline();
    }

    public RenderPipeline pipeline() {
        return this.wrapped.pipeline();
    }

    public void draw(MeshData meshData) {
        this.extra.setupRenderState();
        this.wrapped.draw(meshData);
        this.extra.clearRenderState();
    }

    public boolean sortOnUpload() {
        return this.wrapped.sortOnUpload();
    }

    public RenderPipeline iris$getPipeline() {
        return this.wrapped.iris$getPipeline();
    }

    public RenderTarget iris$getRenderTarget() {
        return this.wrapped.iris$getRenderTarget();
    }

    public boolean canConsolidateConsecutiveGeometry() {
        return this.wrapped.canConsolidateConsecutiveGeometry();
    }

    public boolean affectsCrumbling() {
        return this.wrapped.affectsCrumbling();
    }

    public int bufferSize() {
        return this.wrapped.bufferSize();
    }

    public VertexFormat format() {
        return this.wrapped.format();
    }

    public VertexFormat.Mode mode() {
        return this.wrapped.mode();
    }

    public boolean equals(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        OuterWrappedRenderType other = (OuterWrappedRenderType)((Object)object);
        return Objects.equals(this.wrapped, other.wrapped) && Objects.equals(this.extra, other.extra);
    }

    public int hashCode() {
        return this.wrapped.hashCode() + 1;
    }

    public String toString() {
        return "iris_wrapped:" + this.wrapped.toString();
    }
}

