/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui.message.render;

import java.util.Iterator;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import org.joml.Matrix3x2fStack;
import xaero.map.gui.message.Message;
import xaero.map.gui.message.MessageBox;

public class MessageBoxRenderer {
    private final int OPAQUE_FOR = 5000;
    private final int FADE_FOR = 3000;

    public void render(GuiGraphics guiGraphics, MessageBox messageBox, Font font, int x, int y, boolean rightAlign) {
        Message message;
        int passed;
        float opacity;
        int alphaInt;
        Matrix3x2fStack matrixStack = guiGraphics.pose();
        long time = System.currentTimeMillis();
        matrixStack.pushMatrix();
        matrixStack.translate((float)x, (float)y);
        int index = 0;
        Iterator<Message> iterator = messageBox.getIterator();
        while (iterator.hasNext() && (alphaInt = (int)((opacity = (passed = (int)(time - (message = iterator.next()).getAdditionTime())) < 5000 ? 1.0f : (float)(3000 - (passed - 5000)) / 3000.0f) * 255.0f)) > 3) {
            int textColor = 0xFFFFFF | alphaInt << 24;
            int bgColor = (int)(0.5f * (float)alphaInt) << 24;
            int textWidth = font.width((FormattedText)message.getText());
            int textX = rightAlign ? -textWidth - 1 : 2;
            int textY = -index * 10 - 4;
            int bgWidth = textWidth + 3;
            guiGraphics.fill(textX - 2, textY - 1, textX - 2 + bgWidth, textY + 9, bgColor);
            guiGraphics.drawString(font, message.getText(), textX, textY, textColor);
            ++index;
        }
        matrixStack.popMatrix();
    }
}

