/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.waypoint;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.ScrollListLayoutPane;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.waypointmanager.ManagerSlot;
import journeymap.client.ui.waypointmanager.waypoint.WaypointSlot;
import journeymap.common.Journeymap;
import net.minecraft.class_1043;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4587;

public class WaypointPanel<T extends WaypointSlot>
extends ScrollListLayoutPane<T> {
    WaypointSlot draggingSlot = null;

    public WaypointPanel(class_310 mc, int x, int y, int width, int height, int slotHeight) {
        super(mc, x, y, width, height, slotHeight);
    }

    public int method_25342() {
        return super.method_25342();
    }

    @Override
    protected void renderItem(class_332 graphics, int mouseX, int mouseY, float partialTick, Slot<T> entry) {
        try {
            WaypointSlot slot = (WaypointSlot)entry;
            super.renderItem(graphics, mouseX, mouseY, partialTick, entry);
            if (slot.method_25397()) {
                this.draggingSlot = slot;
            }
            if (this.draggingSlot != null) {
                graphics.method_44380();
                int slotHeight = entry.method_73384();
                if (this.draggingSlot.isSelected()) {
                    List<WaypointSlot> slots = this.getRootSlots().stream().filter(WaypointSlot::isSelected).toList();
                    int boxWidth = this.draggingSlot.name.method_25368() + this.draggingSlot.icon.method_25368() + 20;
                    int boxHeight = slotHeight * slots.size();
                    DrawUtil.drawRectangle(graphics, mouseX, mouseY, boxWidth, boxHeight, ManagerSlot.backgroundHover, 0.4f);
                    this.draggingSlot.outline(graphics, mouseX, mouseY - 1, boxWidth, boxHeight + 1, this.draggingSlot.getWaypoint().getRenderColor(), this.field_22765 * 2.0f);
                    this.draggingSlot.renderGhost(graphics, mouseX, mouseY, partialTick);
                    int slotIndex = 1;
                    for (WaypointSlot renderSlot : slots) {
                        if (renderSlot == this.draggingSlot) continue;
                        renderSlot.renderGhost(graphics, mouseX, mouseY + slotHeight * slotIndex++, partialTick);
                    }
                    float texScale = 0.2f;
                    int posX = mouseX + (boxWidth >> 1);
                    int posY = mouseY + (boxHeight >> 1);
                    class_1043 texture = (class_1043)TextureCache.getTexture(TextureCache.MobIconBG);
                    float scaleX = (float)posX - (float)texture.method_4525().method_4307() * texScale / 2.0f;
                    float scaleY = (float)posY - (float)texture.method_4525().method_4323() * texScale / 2.0f;
                    DrawUtil.drawColoredTexture(graphics, TextureCache.MobIconBG, 0xFF0000, 0.4f, scaleX, scaleY, texture.method_4525().method_4307(), texture.method_4525().method_4323(), texScale, 0.0);
                    DrawUtil.drawCenteredLabel(graphics, (class_2561)class_2561.method_43470((String)Integer.toString(slots.size())), posX, posY, null, 0.0f, 0xFFFFFF, 0.8f, 2.0, false);
                } else {
                    int slotWidth = this.draggingSlot.name.method_25368() + this.draggingSlot.icon.method_25368() + 20;
                    DrawUtil.drawRectangle(graphics, mouseX, mouseY, slotWidth, slotHeight, ManagerSlot.backgroundHover, 0.4f);
                    this.draggingSlot.outline(graphics, mouseX, mouseY - 1, slotWidth, slotHeight + 1, this.draggingSlot.getWaypoint().getRenderColor(), this.field_22765 * 2.0f);
                    this.draggingSlot.renderGhost(graphics, mouseX, mouseY, partialTick);
                }
                this.method_49603(graphics);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error rendering waypoint slot item:", t);
        }
    }

    @Override
    public void renderBackground(class_332 graphics, class_4587 poseStack, int i, int j, float f) {
    }

    @Override
    public boolean method_25406(class_11909 event) {
        this.draggingSlot = null;
        return super.method_25406(event);
    }

    @Override
    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (this.method_25405(event.comp_4798(), event.comp_4799()) && this.method_25405(event.comp_4798(), event.comp_4799())) {
            this.getRootSlots().forEach(slot -> slot.getLayout().method_48206(widget -> widget.method_25402(event, doubleClick)));
            return super.method_25402(event, doubleClick);
        }
        return false;
    }

    public List<WaypointSlot> getDraggingSlots() {
        if (this.draggingSlot != null) {
            if (this.draggingSlot.isSelected()) {
                return this.getRootSlots().stream().filter(WaypointSlot::isSelected).collect(Collectors.toList());
            }
            return Lists.newArrayList((Object[])new WaypointSlot[]{this.draggingSlot});
        }
        return null;
    }

    @Override
    public void visitSlots(Consumer<class_339> consumer) {
        this.getRootSlots().forEach(slot -> {
            if (slot != null && slot.getLayout() != null) {
                slot.getLayout().method_48206(consumer);
            }
        });
    }

    @Override
    public void initSlots() {
        this.getRootSlots().forEach(WaypointSlot::init);
    }

    @Override
    public void repositionSlots() {
        this.getRootSlots().forEach(WaypointSlot::repositionElements);
    }
}

