/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.config;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_12249;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5601;
import net.minecraft.class_5602;
import net.minecraft.class_5607;
import net.minecraft.class_5616;
import net.minecraft.class_630;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import traben.entity_model_features.EMFManager;
import traben.entity_model_features.models.EMFModelMappings;
import traben.entity_model_features.models.EMFModel_ID;
import traben.entity_model_features.models.animation.math.methods.MethodRegistry;
import traben.entity_model_features.models.animation.math.variables.VariableRegistry;
import traben.entity_model_features.models.animation.math.variables.factories.UniqueVariableFactory;
import traben.entity_model_features.utils.EMFEntity;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_model_features.utils.IEMFUnmodifiedLayerRootGetter;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.config.ETFConfig;
import traben.tconfig.TConfig;
import traben.tconfig.gui.TConfigScreenList;
import traben.tconfig.gui.entries.TConfigEntry;
import traben.tconfig.gui.entries.TConfigEntryBoolean;
import traben.tconfig.gui.entries.TConfigEntryCategory;
import traben.tconfig.gui.entries.TConfigEntryCustomButton;
import traben.tconfig.gui.entries.TConfigEntryEnumButton;
import traben.tconfig.gui.entries.TConfigEntryEnumSlider;
import traben.tconfig.gui.entries.TConfigEntryInt;
import traben.tconfig.gui.entries.TConfigEntryText;

public class EMFConfig
extends TConfig {
    public boolean logModelCreationData = false;
    public boolean debugOnRightClick = false;
    public RenderModeChoice renderModeChoice = RenderModeChoice.NORMAL;
    public VanillaModelRenderMode vanillaModelHologramRenderMode_2 = VanillaModelRenderMode.OFF;
    public ModelPrintMode modelExportMode = ModelPrintMode.NONE;
    public ETFConfig.UpdateFrequency modelUpdateFrequency = ETFConfig.UpdateFrequency.Average;
    public ETFConfig.String2EnumNullMap<RenderModeChoice> entityRenderModeOverrides = new ETFConfig.String2EnumNullMap();
    public ETFConfig.String2EnumNullMap<VanillaModelRenderMode> entityVanillaHologramOverrides = new ETFConfig.String2EnumNullMap();
    public ObjectOpenHashSet<String> modelsNamesDisabled = new ObjectOpenHashSet();
    public boolean allowEBEModConfigModify = true;
    public int animationLODDistance = 20;
    public boolean retainDetailOnLowFps = true;
    public boolean retainDetailOnLargerMobs = true;
    public boolean animationFrameSkipDuringIrisShadowPass = true;
    public boolean preventFirstPersonHandAnimating = false;
    public boolean onlyClientPlayerModel = false;
    public boolean doubleChestAnimFix = true;
    @Deprecated(since="2.4.1", forRemoval=true)
    public boolean enforceOptifineVariationRequiresDefaultModel = false;
    public boolean enforceOptifineVariationRequiresDefaultModel_v2 = false;
    @Deprecated(since="2.4.1", forRemoval=true)
    public boolean resetPlayerModelEachRender = true;
    public boolean resetPlayerModelEachRender_v2 = true;
    public boolean onlyDebugRenderOnHover = false;
    public boolean enforceOptifineSubFoldersVariantOnly = true;
    public boolean enforceOptiFineAnimSyntaxLimits = true;
    public boolean allowOptifineFallbackProperties = true;
    public boolean showReloadErrorToast = true;
    public boolean armorCopiesAnimationsHack = true;

    public RenderModeChoice getRenderModeFor(EMFEntity entity) {
        String typeString = EMFConfig.getTypeString(entity);
        if (typeString == null) {
            return this.renderModeChoice;
        }
        return Objects.requireNonNullElseGet((RenderModeChoice)this.entityRenderModeOverrides.getNullable(typeString), () -> this.renderModeChoice);
    }

    public VanillaModelRenderMode getVanillaHologramModeFor(EMFEntity entity) {
        String typeString = EMFConfig.getTypeString(entity);
        if (typeString == null) {
            return this.vanillaModelHologramRenderMode_2;
        }
        return Objects.requireNonNullElseGet((VanillaModelRenderMode)this.entityVanillaHologramOverrides.getNullable(typeString), () -> this.vanillaModelHologramRenderMode_2);
    }

    @Nullable
    private static String getTypeString(EMFEntity entity) {
        if (entity instanceof class_2586) {
            class_2586 block = (class_2586)entity;
            return ETFApi.getBlockEntityTypeToTranslationKey((class_2591)block.method_11017());
        }
        if (entity instanceof class_1297) {
            class_1297 realBoy = (class_1297)entity;
            return realBoy.method_5864().method_5882();
        }
        return null;
    }

    public boolean isModelDisabled(String modelName) {
        return this.modelsNamesDisabled.contains((Object)modelName);
    }

    public TConfigEntryCategory getGUIOptions() {
        return new TConfigEntryCategory.Empty().add(new TConfigEntry[]{new TConfigEntryCategory("config.entity_features.models_main").add(new TConfigEntry[]{new TConfigEntryCategory("entity_model_features.config.options", "entity_model_features.config.options.tooltip").add(new TConfigEntry[]{new TConfigEntryBoolean("entity_model_features.config.ebe_config_modify", "entity_model_features.config.ebe_config_modify.tooltip", () -> this.allowEBEModConfigModify, value -> {
            this.allowEBEModConfigModify = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.double_chest_fix", "entity_model_features.config.double_chest_fix.tooltip", () -> this.doubleChestAnimFix, value -> {
            this.doubleChestAnimFix = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.armor_hack", "entity_model_features.config.armor_hack.tooltip", () -> this.armorCopiesAnimationsHack, value -> {
            this.armorCopiesAnimationsHack = value;
        }, true)}), new TConfigEntryCategory("entity_model_features.config.player_settings").add(new TConfigEntry[]{new TConfigEntryBoolean("entity_model_features.config.prevent_hand", "entity_model_features.config.prevent_hand.tooltip", () -> this.preventFirstPersonHandAnimating, value -> {
            this.preventFirstPersonHandAnimating = value;
        }, false), new TConfigEntryBoolean("entity_model_features.config.only_client", "entity_model_features.config.only_client.tooltip", () -> this.onlyClientPlayerModel, value -> {
            this.onlyClientPlayerModel = value;
        }, false), new TConfigEntryBoolean("entity_model_features.config.reset_player", "entity_model_features.config.reset_player.tooltip", () -> this.resetPlayerModelEachRender_v2, value -> {
            this.resetPlayerModelEachRender_v2 = value;
        }, true)}), new TConfigEntryCategory("entity_model_features.config.performance").add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.update", "entity_model_features.config.update.tooltip", () -> this.modelUpdateFrequency, value -> {
            this.modelUpdateFrequency = value;
        }, (Enum)ETFConfig.UpdateFrequency.Average), new TConfigEntryInt("entity_model_features.config.lod", "entity_model_features.config.lod.tooltip", () -> this.animationLODDistance, value -> {
            this.animationLODDistance = value;
        }, 20, 0, 65, true, true), new TConfigEntryBoolean("entity_model_features.config.low_fps_lod", "entity_model_features.config.low_fps_lod.tooltip", () -> this.retainDetailOnLowFps, value -> {
            this.retainDetailOnLowFps = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.large_mob_lod", "entity_model_features.config.large_mob_lod.tooltip", () -> this.retainDetailOnLargerMobs, value -> {
            this.retainDetailOnLargerMobs = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.iris_shadow_skip", "entity_model_features.config.iris_shadow_skip.tooltip", () -> this.animationFrameSkipDuringIrisShadowPass, value -> {
            this.animationFrameSkipDuringIrisShadowPass = value;
        }, true)}), new TConfigEntryCategory("entity_model_features.config.tools", "entity_model_features.config.tools.tooltip").add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.vanilla_render", "entity_model_features.config.vanilla_render.tooltip", () -> this.vanillaModelHologramRenderMode_2, value -> {
            this.vanillaModelHologramRenderMode_2 = value;
        }, (Enum)VanillaModelRenderMode.OFF), new TConfigEntryEnumSlider("entity_model_features.config.print_mode", "entity_model_features.config.print_mode.tooltip", () -> this.modelExportMode, value -> {
            this.modelExportMode = value;
        }, (Enum)ModelPrintMode.NONE)}), new TConfigEntryCategory("entity_model_features.config.debug", "entity_model_features.config.debug.tooltip").add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.render", "entity_model_features.config.render.tooltip", () -> this.renderModeChoice, value -> {
            this.renderModeChoice = value;
        }, (Enum)RenderModeChoice.NORMAL), new TConfigEntryBoolean("entity_model_features.config.debug_hover", "entity_model_features.config.debug_hover.tooltip", () -> this.onlyDebugRenderOnHover, value -> {
            this.onlyDebugRenderOnHover = value;
        }, false), new TConfigEntryBoolean("entity_model_features.config.log_models", "entity_model_features.config.log_models.tooltip", () -> this.logModelCreationData, value -> {
            this.logModelCreationData = value;
        }, false), new TConfigEntryBoolean("entity_model_features.config.debug_right_click", "entity_model_features.config.debug_right_click.tooltip", () -> this.debugOnRightClick, value -> {
            this.debugOnRightClick = value;
        }, false), new TConfigEntryCustomButton("entity_model_features.config.load_warn.title", "entity_model_features.config.load_warn.tooltip", button -> EMFConfig.reprintLoadingErrors(false)), new TConfigEntryCustomButton("entity_model_features.config.load_warn.title2", "entity_model_features.config.load_warn.tooltip", button -> EMFConfig.reprintLoadingErrors(true)), new TConfigEntryBoolean("entity_model_features.config.show_reload_error_toast", "entity_model_features.config.show_reload_error_toast.tooltip", () -> this.showReloadErrorToast, value -> {
            this.showReloadErrorToast = value;
        }, true)}), this.getModelSettings(), this.getMathInfo()}), this.getEntitySettings(), new TConfigEntryCategory("config.entity_features.optifine_settings", "config.entity_texture_features.optifine.desc").add(new TConfigEntry[]{new TConfigEntryBoolean("entity_model_features.config.variation_base", "entity_model_features.config.variation_base.tooltip", () -> this.enforceOptifineVariationRequiresDefaultModel_v2, value -> {
            this.enforceOptifineVariationRequiresDefaultModel_v2 = value;
        }, false), new TConfigEntryBoolean("entity_model_features.config.optifine_subfolders", "entity_model_features.config.optifine_subfolders.tooltip", () -> this.enforceOptifineSubFoldersVariantOnly, value -> {
            this.enforceOptifineSubFoldersVariantOnly = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.optifine_syntax", "entity_model_features.config.optifine_syntax.tooltip", () -> this.enforceOptiFineAnimSyntaxLimits, value -> {
            this.enforceOptiFineAnimSyntaxLimits = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.optifine_fallback_properties", "entity_model_features.config.optifine_fallback_properties.tooltip", () -> this.allowOptifineFallbackProperties, value -> {
            this.allowOptifineFallbackProperties = value;
        }, true)})});
    }

    private static void reprintLoadingErrors(boolean stacktrace) {
        EMFUtils.logError("~~//BEGIN: EMF MASS PRINT OF LOADING ERRORS\\\\~~\nNot all errors here will be helpful as they may be missing surrounding log context.\nThis is best used to know what you might need to be searching for in your log\nor to give the dev debugging info.");
        int i = 1;
        for (Exception loadingException : EMFManager.getInstance().loadingExceptions) {
            System.out.println("----------//Exception #" + i + "\\\\---------- \n" + loadingException.getMessage());
            if (stacktrace) {
                loadingException.printStackTrace();
            }
            ++i;
        }
        EMFUtils.logError("~~\\\\END: EMF MASS PRINT OF LOADING ERRORS//~~");
    }

    private TConfigEntryCategory getMathInfo() {
        TConfigEntryCategory category = new TConfigEntryCategory("entity_model_features.config.math");
        category.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.math.explain", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        TConfigEntryCategory variables = new TConfigEntryCategory("entity_model_features.config.variables");
        category.add((TConfigEntry)variables);
        variables.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.variables.explain", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        for (UniqueVariableFactory uniqueVariableFactory : VariableRegistry.getInstance().getUniqueVariableFactories()) {
            TConfigEntryCategory unique = new TConfigEntryCategory(uniqueVariableFactory.getTitleTranslationKey()).addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)uniqueVariableFactory.getExplanationTranslationKey(), (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            variables.add((TConfigEntry)unique);
        }
        VariableRegistry.getInstance().getSingletonVariableExplanationTranslationKeys().keySet().stream().sorted().forEach(key -> {
            String value = VariableRegistry.getInstance().getSingletonVariableExplanationTranslationKeys().get(key);
            TConfigEntryCategory unique = new TConfigEntryCategory(key).addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)value, (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            variables.add((TConfigEntry)unique);
        });
        TConfigEntryCategory methods = new TConfigEntryCategory("entity_model_features.config.functions");
        category.add((TConfigEntry)methods);
        methods.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.functions.explain", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        MethodRegistry.getInstance().getMethodExplanationTranslationKeys().keySet().stream().sorted().forEach(key -> {
            String value = MethodRegistry.getInstance().getMethodExplanationTranslationKeys().get(key);
            TConfigEntryCategory method = new TConfigEntryCategory(key + "()").addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)value, (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            methods.add((TConfigEntry)method);
        });
        return category;
    }

    private TConfigEntryCategory getModelSettings() {
        TConfigEntryCategory category = new TConfigEntryCategory("entity_model_features.config.models");
        category.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.models_text", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        EMFManager.getInstance().cache_LayersByModelName.put((Object)new EMFModel_ID("wolf_collar"), (Object)class_5602.field_27636);
        EMFManager.getInstance().cache_LayersByModelName.keySet().stream().sorted().forEach(mapData -> {
            class_5607 vanilla;
            class_5601 layer = (class_5601)EMFManager.getInstance().cache_LayersByModelName.get(mapData);
            if (layer != null && (vanilla = (class_5607)class_310.method_1551().method_31974().field_27542.get(layer)) != null) {
                String namespace = "minecraft".equals(mapData.getNamespace()) ? "" : mapData.getNamespace() + ":";
                String fileName = namespace + mapData.getfileName();
                TConfigEntryCategory model = new TConfigEntryCategory(fileName + ".jem");
                model.setAlign(TConfigScreenList.Align.RIGHT);
                model.setWidgetBackgroundToFullWidth();
                model.setRenderFeature((TConfigScreenList.Renderable)new ModelRootRenderer(layer));
                category.add((TConfigEntry)model);
                StringBuilder fallbacks = new StringBuilder();
                mapData.forEachFallback(fallBackData -> fallbacks.append(fallBackData.getfileName()).append(".jem\n"));
                model.add(new TConfigEntry[]{new TConfigEntryBoolean("entity_model_features.config.models.enabled", "entity_model_features.config.models.enabled.tooltip", () -> !this.modelsNamesDisabled.contains((Object)fileName), value -> {
                    if (value.booleanValue()) {
                        this.modelsNamesDisabled.remove((Object)fileName);
                    } else {
                        this.modelsNamesDisabled.add((Object)fileName);
                    }
                }, true), new TConfigEntryCategory("entity_model_features.config.models.part_names").addAll(this.getmappings(mapData.getMapId())), this.getExport((EMFModel_ID)mapData, layer), new TConfigEntryCategory("entity_model_features.config.models.file_names").addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)("<Folders>\nassets/" + mapData.getNamespace() + "/emf/cem/\nassets/" + mapData.getNamespace() + "/optifine/cem/\n\n<possible model names>\n<checked from top down>\n" + mapData.getfileName() + ".jem\n" + String.valueOf(fallbacks)), (int)600, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.CENTER))}).addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.models.explain", (int)100, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            }
        });
        return category;
    }

    @NotNull
    private TConfigEntry getExport(EMFModel_ID key, class_5601 layer) {
        TConfigEntryText.TwoLines export;
        try {
            Objects.requireNonNull(key.getMapId());
            export = new TConfigEntryCustomButton("entity_model_features.config.models.export", "entity_model_features.config.models.export.tooltip", button -> {
                ModelPrintMode old = this.modelExportMode;
                this.modelExportMode = ModelPrintMode.ALL_LOG_AND_JEM;
                try {
                    EMFModelMappings.getMapOf(key, Objects.requireNonNullElseGet(((IEMFUnmodifiedLayerRootGetter)class_310.method_1551().method_31974()).emf$getUnmodifiedRoots().get(layer), () -> (class_5607)class_310.method_1551().method_31974().field_27542.get(layer)).method_32109(), false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.modelExportMode = old;
                button.field_22763 = false;
                button.method_25355((class_2561)class_2561.method_43471((String)"entity_model_features.config.models.export.success"));
            });
        }
        catch (Exception e) {
            export = new TConfigEntryText.TwoLines("entity_model_features.config.models.export.fail", e.getMessage());
        }
        return export;
    }

    private Collection<TConfigEntry> getmappings(String mapKey) {
        Map<String, String> map;
        ArrayList<TConfigEntry> list = new ArrayList<TConfigEntry>();
        if (EMFModelMappings.OPTIFINE_MODEL_MAP_CACHE.containsKey(mapKey)) {
            list.add((TConfigEntry)new TConfigEntryText("entity_model_features.config.variable_explanation.optifine_parts"));
            list.add((TConfigEntry)new TConfigEntryText("\\/"));
            map = EMFModelMappings.OPTIFINE_MODEL_MAP_CACHE.get(mapKey);
        } else {
            list.add((TConfigEntry)new TConfigEntryText("entity_model_features.config.variable_explanation.unknown_parts"));
            list.add((TConfigEntry)new TConfigEntryText("\\/"));
            map = EMFModelMappings.UNKNOWN_MODEL_MAP_CACHE.get(mapKey);
        }
        if (map == null) {
            return List.of();
        }
        for (String entry : map.keySet()) {
            list.add((TConfigEntry)new TConfigEntryText(entry));
        }
        return list;
    }

    private TConfigEntryCategory getEntitySettings() {
        TConfigEntryCategory category = new TConfigEntryCategory("config.entity_features.per_entity_settings");
        try {
            class_7923.field_41177.forEach(entityType -> {
                String translationKey = entityType.method_5882();
                TConfigEntryCategory entityCategory = new TConfigEntryCategory(translationKey);
                this.addEntityConfigs(entityCategory, translationKey);
                category.add((TConfigEntry)entityCategory);
            });
            class_5616.field_27752.keySet().forEach(entityType -> {
                String translationKey = ETFApi.getBlockEntityTypeToTranslationKey((class_2591)entityType);
                TConfigEntryCategory entityCategory = new TConfigEntryCategory(translationKey);
                this.addEntityConfigs(entityCategory, translationKey);
                category.add((TConfigEntry)entityCategory);
            });
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        return category;
    }

    private void addEntityConfigs(TConfigEntryCategory entityCategory, String translationKey) {
        TConfigEntryCategory category = new TConfigEntryCategory("config.entity_features.models_main");
        entityCategory.add((TConfigEntry)category);
        category.add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.render", "entity_model_features.config.render.tooltip", () -> (RenderModeChoice)this.entityRenderModeOverrides.getNullable(translationKey), layer -> this.entityRenderModeOverrides.putNullable(translationKey, (Enum)layer), null, RenderModeChoice.class), new TConfigEntryEnumButton("entity_model_features.config.vanilla_render", "entity_model_features.config.vanilla_render.tooltip", () -> (VanillaModelRenderMode)this.entityVanillaHologramOverrides.getNullable(translationKey), layer -> this.entityVanillaHologramOverrides.putNullable(translationKey, (Enum)layer), null, VanillaModelRenderMode.class)});
    }

    public class_2960 getModIcon() {
        return EMFUtils.res("entity_model_features", "textures/gui/icon.png");
    }

    public static enum RenderModeChoice {
        NORMAL("entity_model_features.config.render.normal"),
        GREEN("entity_model_features.config.render.green"),
        LINES_AND_TEXTURE("entity_model_features.config.render.lines_texture"),
        LINES_AND_TEXTURE_FLASH("entity_model_features.config.render.lines_texture_flash"),
        LINES("entity_model_features.config.render.lines"),
        NONE("entity_model_features.config.render.none");

        private final String text;

        private RenderModeChoice(String text) {
            this.text = text;
        }

        public String toString() {
            return class_2561.method_43471((String)this.text).getString();
        }
    }

    public static enum VanillaModelRenderMode {
        OFF("options.off"),
        NORMAL("entity_model_features.config.vanilla_render.normal"),
        OFFSET("entity_model_features.config.vanilla_render.offset");

        private final String text;

        private VanillaModelRenderMode(String text) {
            this.text = text;
        }

        public String toString() {
            return class_2561.method_43471((String)this.text).getString();
        }
    }

    public static enum ModelPrintMode {
        NONE("options.off"),
        LOG_ONLY("entity_model_features.config.print_mode.log"),
        LOG_AND_JEM("entity_model_features.config.print_mode.log_jem"),
        ALL_LOG_ONLY("entity_model_features.config.print_mode.all_log"),
        ALL_LOG_AND_JEM("entity_model_features.config.print_mode.all_log_jem");

        private final String text;

        private ModelPrintMode(String text) {
            this.text = text;
        }

        public boolean doesJems() {
            return this == LOG_AND_JEM || this == ALL_LOG_AND_JEM;
        }

        public boolean doesAll() {
            return this == ALL_LOG_ONLY || this == ALL_LOG_AND_JEM;
        }

        public boolean doesLog() {
            return this != NONE;
        }

        public String toString() {
            return class_2561.method_43471((String)this.text).getString();
        }
    }

    private static class ModelRootRenderer
    implements TConfigScreenList.Renderable {
        private final class_5601 layer;
        private class_630 root = null;
        private boolean asserted = false;

        ModelRootRenderer(class_5601 layer) {
            this.layer = layer;
        }

        private boolean canRender() {
            if (!this.asserted && this.root == null) {
                this.asserted = true;
                try {
                    this.root = ((class_5607)class_310.method_1551().method_31974().field_27542.get(this.layer)).method_32109();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this.root != null;
        }

        public void render(class_332 context, int mouseX, int mouseY) {
            if (this.canRender()) {
                class_437 screen = class_310.method_1551().field_1755;
                if (screen == null) {
                    return;
                }
                int y = (int)((double)screen.field_22790 * 0.75);
                int x = (int)((double)screen.field_22789 * 0.33);
                float g = (float)(-Math.atan(((float)(-mouseY) + (float)screen.field_22790 / 2.0f) / 40.0f));
                float g2 = (float)(-Math.atan(((float)(-mouseX) + (float)screen.field_22789 / 3.0f) / 400.0f));
                Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI).rotateY(g2 * 8.0f);
                Quaternionf quaternionf2 = new Quaternionf().rotateX(-(g * 20.0f * ((float)Math.PI / 180)) * 2.0f);
                quaternionf.mul((Quaternionfc)quaternionf2);
                class_4587 matrixStack = new class_4587();
                matrixStack.method_22903();
                matrixStack.method_22904((double)x, (double)y, 150.0);
                float scaling = (float)((double)screen.field_22790 * 0.3);
                matrixStack.method_34425((Matrix4fc)new Matrix4f().scaling(scaling, scaling, -scaling));
                matrixStack.method_22907((Quaternionfc)quaternionf);
                matrixStack.method_22903();
                matrixStack.method_22905(-1.0f, -1.0f, 1.0f);
                matrixStack.method_46416(0.0f, -1.501f, 0.0f);
                class_4588 buffer = class_310.method_1551().method_22940().method_23000().method_73477(class_12249.method_76015());
                if (buffer != null) {
                    this.renderBoxes(matrixStack, buffer, this.root);
                }
                matrixStack.method_22909();
            }
        }

        private void renderBoxes(class_4587 matrices, class_4588 vertices, class_630 modelPart) {
            if (!(!modelPart.field_3665 || modelPart.field_3663.isEmpty() && modelPart.field_3661.isEmpty())) {
                matrices.method_22903();
                modelPart.method_22703(matrices);
                if (!modelPart.field_38456) {
                    for (class_630.class_628 cuboid : modelPart.field_3663) {
                        class_238 box = new class_238((double)(cuboid.field_3645 / 16.0f), (double)(cuboid.field_3644 / 16.0f), (double)(cuboid.field_3643 / 16.0f), (double)(cuboid.field_3648 / 16.0f), (double)(cuboid.field_3647 / 16.0f), (double)(cuboid.field_3646 / 16.0f));
                        EMFUtils.renderLineBox(matrices.method_23760(), vertices, box, 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                }
                for (class_630 modelPartChildren : modelPart.field_3661.values()) {
                    this.renderBoxes(matrices, vertices, modelPartChildren);
                }
                matrices.method_22909();
            }
        }
    }
}

