/*
 * Decompiled with CFR 0.152.
 */
package traben.tconfig.gui.entries;

import com.demonwav.mcdev.annotations.Translatable;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import traben.tconfig.gui.TConfigScreenList;
import traben.tconfig.gui.entries.TConfigEntry;

public class TConfigEntryCategory
extends TConfigEntry {
    private final Object2ObjectLinkedOpenHashMap<String, TConfigEntry> options = new Object2ObjectLinkedOpenHashMap();
    private final String translationKey;
    protected boolean fullWidthBackgroundEvenIfSmaller = false;
    private TConfigScreenList screen = null;
    private class_7919 emptyTooltip = class_7919.method_47407((class_2561)class_2561.method_43471((String)"config.entity_features.empty"));
    private TConfigScreenList.Align align = TConfigScreenList.Align.CENTER;
    private TConfigScreenList.Renderable renderFeature = null;

    public TConfigEntryCategory(@Translatable String text, @Translatable String tooltip) {
        super(text, tooltip);
        this.translationKey = text;
    }

    public TConfigEntryCategory(@Translatable String text) {
        super(text, null);
        this.translationKey = text;
    }

    public void setAlign(TConfigScreenList.Align align) {
        this.align = align;
    }

    public Object2ObjectLinkedOpenHashMap<String, TConfigEntry> getOptions() {
        return this.options;
    }

    public TConfigScreenList getScreen() {
        if (this.screen == null) {
            this.screen = new TConfigScreenList(this.translationKey, class_310.method_1551().field_1755, (TConfigEntry[])this.options.values().toArray((Object[])new TConfigEntry[0]), this::setValuesToDefault, this::resetValuesToInitial, this.align);
            this.screen.setRenderFeature(this.renderFeature);
            if (this.fullWidthBackgroundEvenIfSmaller) {
                this.screen.setWidgetBackgroundToFullWidth();
            }
        }
        return this.screen;
    }

    @Override
    public class_339 getWidget(int x, int y, int width, int height) {
        return new CategoryButton(x, y, width, height, this.getText(), button -> class_310.method_1551().method_1507((class_437)this.getScreen()));
    }

    @Override
    public boolean saveValuesToConfig() {
        boolean found = false;
        for (TConfigEntry option : this.options.values()) {
            found |= option.saveValuesToConfig();
        }
        return found;
    }

    public void setWidgetBackgroundToFullWidth() {
        this.fullWidthBackgroundEvenIfSmaller = true;
    }

    @Override
    public void setValuesToDefault() {
        for (TConfigEntry option : this.options.values()) {
            option.setValuesToDefault();
        }
    }

    @Override
    public void resetValuesToInitial() {
        for (TConfigEntry option : this.options.values()) {
            option.resetValuesToInitial();
        }
    }

    public TConfigEntryCategory add(TConfigEntry ... option) {
        for (TConfigEntry tConfigEntry : option) {
            this.add(tConfigEntry);
        }
        return this;
    }

    public TConfigEntryCategory addAll(Collection<TConfigEntry> option) {
        if (option != null) {
            option.forEach(this::add);
        }
        return this;
    }

    public TConfigEntryCategory add(TConfigEntry option) {
        if (option == null) {
            return this;
        }
        if (option instanceof TConfigEntryCategory) {
            TConfigEntryCategory category = (TConfigEntryCategory)option;
            return this.addOrMerge(category);
        }
        this.options.put((Object)option.getText().getString(), (Object)option);
        return this;
    }

    private TConfigEntryCategory addOrMerge(TConfigEntryCategory category) {
        Object object;
        String categoryKey = category.getText().getString();
        if (this.options.containsKey((Object)categoryKey) && (object = this.options.get((Object)categoryKey)) instanceof TConfigEntryCategory) {
            TConfigEntryCategory existingCategory = (TConfigEntryCategory)((Object)object);
            category.options.values().forEach(existingCategory::add);
        } else {
            this.options.put((Object)categoryKey, (Object)category);
        }
        return this;
    }

    @Override
    boolean hasChangedFromInitial() {
        return this.options.values().stream().anyMatch(TConfigEntry::hasChangedFromInitial);
    }

    public TConfigEntryCategory setEmptyTooltip(@NotNull @Translatable String emptyTooltipKey) {
        this.emptyTooltip = class_7919.method_47407((class_2561)class_2561.method_43471((String)emptyTooltipKey));
        return this;
    }

    public void setRenderFeature(TConfigScreenList.Renderable renderFeature) {
        this.renderFeature = renderFeature;
    }

    private class CategoryButton
    extends class_4185.class_12231 {
        protected CategoryButton(int x, int y, int width, int height, class_2561 message, class_4185.class_4241 onPress) {
            super(x, y, width, height, message, onPress, Supplier::get);
            boolean bl = this.field_22763 = !TConfigEntryCategory.this.options.isEmpty();
            if (!this.field_22763) {
                this.method_47400(TConfigEntryCategory.this.emptyTooltip);
            }
        }

        @NotNull
        public class_2561 method_25369() {
            return TConfigEntryCategory.this.hasChangedFromInitial() ? class_2561.method_30163((String)("\u00a7a" + super.method_25369().getString())) : super.method_25369();
        }
    }

    public static class Empty
    extends TConfigEntryCategory {
        public Empty() {
            super("", null);
        }

        @Override
        public class_339 getWidget(int x, int y, int width, int height) {
            return null;
        }
    }
}

