/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.shadowed.blue.endless.jankson.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class Escaper {
    private static final Set<Character.UnicodeBlock> DEFAULT_BLOCKS;

    private Escaper() {
    }

    public static String escapeString(String s) {
        return Escaper.escapeString(s, '\"', DEFAULT_BLOCKS);
    }

    public static String escapeString(String s, char quoteChar, Set<Character.UnicodeBlock> unquotedBlocks) {
        StringBuilder result = new StringBuilder(s.length());
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\\': {
                    result.append("\\\\");
                    continue block10;
                }
                case '\r': {
                    result.append("\\r");
                    continue block10;
                }
                case '\n': {
                    result.append("\\n");
                    continue block10;
                }
                case '\b': {
                    result.append("\\b");
                    continue block10;
                }
                case '\f': {
                    result.append("\\f");
                    continue block10;
                }
                case '\t': {
                    result.append("\\t");
                    continue block10;
                }
                case '\"': {
                    if (quoteChar == ch) {
                        result.append("\\\"");
                        continue block10;
                    }
                    result.append(ch);
                    continue block10;
                }
                case '\'': {
                    if (quoteChar == ch) {
                        result.append("\\'");
                        continue block10;
                    }
                    result.append(ch);
                    continue block10;
                }
                default: {
                    if (Character.isBmpCodePoint(ch)) {
                        Character.UnicodeBlock block = Character.UnicodeBlock.of(ch);
                        if (ch != '\uffff' && !Character.isISOControl(ch) && block != null && unquotedBlocks.contains(block)) {
                            result.append(ch);
                            continue block10;
                        }
                        result.append(Escaper.unicodeEscape(ch));
                        continue block10;
                    }
                    char upper = s.charAt(++i);
                    int codePoint = Character.toCodePoint(ch, upper);
                    result.append(Escaper.unicodeEscape(codePoint));
                }
            }
        }
        return result.toString();
    }

    private static String unicodeEscape(int codePoint) {
        String codeString = "" + Integer.toHexString(codePoint);
        while (codeString.length() < 4) {
            codeString = "0" + codeString;
        }
        return "\\u" + codeString;
    }

    static {
        HashSet<Character.UnicodeBlock> tmp = new HashSet<Character.UnicodeBlock>();
        tmp.add(Character.UnicodeBlock.BASIC_LATIN);
        DEFAULT_BLOCKS = Collections.unmodifiableSet(tmp);
    }
}

