/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.matrix;

import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3c;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.Vec3f;

public class IntMatrix3
implements IntMatrix3c {
    private int m00;
    private int m01;
    private int m02;
    private int m10;
    private int m11;
    private int m12;
    private int m20;
    private int m21;
    private int m22;

    private static int fma(int a, int b, int c) {
        return a * b + c;
    }

    public IntMatrix3() {
        this(1, 0, 0, 0, 1, 0, 0, 0, 1);
    }

    public IntMatrix3(int[] array) {
        if (array.length != 9) {
            throw new IllegalArgumentException();
        }
        this.m00 = array[0];
        this.m01 = array[1];
        this.m02 = array[2];
        this.m10 = array[3];
        this.m11 = array[4];
        this.m12 = array[5];
        this.m20 = array[6];
        this.m21 = array[7];
        this.m22 = array[8];
    }

    public IntMatrix3(int m00, int m01, int m02, int m10, int m11, int m12, int m20, int m21, int m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
    }

    public IntMatrix3(IntMatrix3c matrix) {
        this.m00 = matrix.m00();
        this.m01 = matrix.m01();
        this.m02 = matrix.m02();
        this.m10 = matrix.m10();
        this.m11 = matrix.m11();
        this.m12 = matrix.m12();
        this.m20 = matrix.m20();
        this.m21 = matrix.m21();
        this.m22 = matrix.m22();
    }

    public IntMatrix3(IntMatrix3c m1, IntMatrix3c m2) {
        this.m00 = m1.m00() * m2.m00() + m1.m01() * m2.m10() + m1.m02() * m2.m20();
        this.m01 = m1.m00() * m2.m01() + m1.m01() * m2.m11() + m1.m02() * m2.m21();
        this.m02 = m1.m00() * m2.m02() + m1.m01() * m2.m12() + m1.m02() * m2.m22();
        this.m10 = m1.m10() * m2.m00() + m1.m11() * m2.m10() + m1.m12() * m2.m20();
        this.m11 = m1.m10() * m2.m01() + m1.m11() * m2.m11() + m1.m12() * m2.m21();
        this.m12 = m1.m10() * m2.m02() + m1.m11() * m2.m12() + m1.m12() * m2.m22();
        this.m20 = m1.m20() * m2.m00() + m1.m21() * m2.m10() + m1.m22() * m2.m20();
        this.m21 = m1.m20() * m2.m01() + m1.m21() * m2.m11() + m1.m22() * m2.m21();
        this.m22 = m1.m20() * m2.m02() + m1.m21() * m2.m12() + m1.m22() * m2.m22();
    }

    @Override
    public int getX(int[] vec) {
        return this.getX(vec[0], vec[1], vec[2]);
    }

    @Override
    public int getX(class_2382 vec) {
        return this.getX(vec.method_10263(), vec.method_10264(), vec.method_10260());
    }

    @Override
    public int getX(int x, int y, int z) {
        return x * this.m00 + y * this.m01 + z * this.m02;
    }

    @Override
    public long getX(long x, long y, long z) {
        return x * (long)this.m00 + y * (long)this.m01 + z * (long)this.m02;
    }

    @Override
    public int getY(int[] vec) {
        return this.getY(vec[0], vec[1], vec[2]);
    }

    @Override
    public int getY(class_2382 vec) {
        return this.getY(vec.method_10263(), vec.method_10264(), vec.method_10260());
    }

    @Override
    public int getY(int x, int y, int z) {
        return x * this.m10 + y * this.m11 + z * this.m12;
    }

    @Override
    public long getY(long x, long y, long z) {
        return x * (long)this.m10 + y * (long)this.m11 + z * (long)this.m12;
    }

    @Override
    public int getZ(int[] vec) {
        return this.getZ(vec[0], vec[1], vec[2]);
    }

    @Override
    public int getZ(class_2382 vec) {
        return this.getZ(vec.method_10263(), vec.method_10264(), vec.method_10260());
    }

    @Override
    public int getZ(int x, int y, int z) {
        return x * this.m20 + y * this.m21 + z * this.m22;
    }

    @Override
    public long getZ(long x, long y, long z) {
        return x * (long)this.m20 + y * (long)this.m21 + z * (long)this.m22;
    }

    @Override
    public class_2338 transform(class_2338 vec) {
        int x = vec.method_10263() * this.m00 + vec.method_10264() * this.m01 + vec.method_10260() * this.m02;
        int y = vec.method_10263() * this.m10 + vec.method_10264() * this.m11 + vec.method_10260() * this.m12;
        int z = vec.method_10263() * this.m20 + vec.method_10264() * this.m21 + vec.method_10260() * this.m22;
        return new class_2338(x, y, z);
    }

    @Override
    public class_2382 transform(class_2382 vec) {
        int x = vec.method_10263() * this.m00 + vec.method_10264() * this.m01 + vec.method_10260() * this.m02;
        int y = vec.method_10263() * this.m10 + vec.method_10264() * this.m11 + vec.method_10260() * this.m12;
        int z = vec.method_10263() * this.m20 + vec.method_10264() * this.m21 + vec.method_10260() * this.m22;
        return new class_2382(x, y, z);
    }

    @Override
    public class_243 transform(class_243 vec) {
        double x = vec.field_1352 * (double)this.m00 + vec.field_1351 * (double)this.m01 + vec.field_1350 * (double)this.m02;
        double y = vec.field_1352 * (double)this.m10 + vec.field_1351 * (double)this.m11 + vec.field_1350 * (double)this.m12;
        double z = vec.field_1352 * (double)this.m20 + vec.field_1351 * (double)this.m21 + vec.field_1350 * (double)this.m22;
        return new class_243(x, y, z);
    }

    @Override
    public void transform(Vec3d triple) {
        double x = triple.x * (double)this.m00 + triple.y * (double)this.m01 + triple.z * (double)this.m02;
        double y = triple.x * (double)this.m10 + triple.y * (double)this.m11 + triple.z * (double)this.m12;
        double z = triple.x * (double)this.m20 + triple.y * (double)this.m21 + triple.z * (double)this.m22;
        triple.set(x, y, z);
    }

    @Override
    public void transform(Vec3f triple) {
        float x = triple.x * (float)this.m00 + triple.y * (float)this.m01 + triple.z * (float)this.m02;
        float y = triple.x * (float)this.m10 + triple.y * (float)this.m11 + triple.z * (float)this.m12;
        float z = triple.x * (float)this.m20 + triple.y * (float)this.m21 + triple.z * (float)this.m22;
        triple.set(x, y, z);
    }

    public IntMatrix3c mul(IntMatrix3c right) {
        return this.mul(right, this);
    }

    public IntMatrix3c mul(IntMatrix3c right, IntMatrix3 dest) {
        int nm00 = IntMatrix3.fma(this.m00, right.m00(), IntMatrix3.fma(this.m10, right.m01(), this.m20 * right.m02()));
        int nm01 = IntMatrix3.fma(this.m01, right.m00(), IntMatrix3.fma(this.m11, right.m01(), this.m21 * right.m02()));
        int nm02 = IntMatrix3.fma(this.m02, right.m00(), IntMatrix3.fma(this.m12, right.m01(), this.m22 * right.m02()));
        int nm10 = IntMatrix3.fma(this.m00, right.m10(), IntMatrix3.fma(this.m10, right.m11(), this.m20 * right.m12()));
        int nm11 = IntMatrix3.fma(this.m01, right.m10(), IntMatrix3.fma(this.m11, right.m11(), this.m21 * right.m12()));
        int nm12 = IntMatrix3.fma(this.m02, right.m10(), IntMatrix3.fma(this.m12, right.m11(), this.m22 * right.m12()));
        int nm20 = IntMatrix3.fma(this.m00, right.m20(), IntMatrix3.fma(this.m10, right.m21(), this.m20 * right.m22()));
        int nm21 = IntMatrix3.fma(this.m01, right.m20(), IntMatrix3.fma(this.m11, right.m21(), this.m21 * right.m22()));
        int nm22 = IntMatrix3.fma(this.m02, right.m20(), IntMatrix3.fma(this.m12, right.m21(), this.m22 * right.m22()));
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        return dest;
    }

    public boolean equals(Object object) {
        if (object instanceof IntMatrix3) {
            IntMatrix3 m1 = (IntMatrix3)object;
            return this.m00 == m1.m00 && this.m01 == m1.m01 && this.m02 == m1.m02 && this.m10 == m1.m10 && this.m11 == m1.m11 && this.m12 == m1.m12 && this.m20 == m1.m20 && this.m21 == m1.m21 && this.m22 == m1.m22;
        }
        return false;
    }

    public String toString() {
        return this.m00 + ", " + this.m01 + ", " + this.m02 + "\n" + this.m10 + ", " + this.m11 + ", " + this.m12 + "\n" + this.m20 + ", " + this.m21 + ", " + this.m22 + "\n";
    }

    @Override
    public int m00() {
        return this.m00;
    }

    @Override
    public int m01() {
        return this.m01;
    }

    @Override
    public int m02() {
        return this.m02;
    }

    @Override
    public int m10() {
        return this.m10;
    }

    @Override
    public int m11() {
        return this.m11;
    }

    @Override
    public int m12() {
        return this.m12;
    }

    @Override
    public int m20() {
        return this.m20;
    }

    @Override
    public int m21() {
        return this.m21;
    }

    @Override
    public int m22() {
        return this.m22;
    }

    @Override
    public boolean invertedX() {
        return this.m00 != 0 ? this.m00 < 0 : (this.m01 != 0 ? this.m01 < 0 : this.m02 < 0);
    }

    @Override
    public <T> T getX(T x, T y, T z) {
        return this.m00 != 0 ? x : (this.m01 != 0 ? y : z);
    }

    @Override
    public boolean invertedY() {
        return this.m10 != 0 ? this.m10 < 0 : (this.m11 != 0 ? this.m11 < 0 : this.m12 < 0);
    }

    @Override
    public <T> T getY(T x, T y, T z) {
        return this.m10 != 0 ? x : (this.m11 != 0 ? y : z);
    }

    @Override
    public boolean invertedZ() {
        return this.m20 != 0 ? this.m20 < 0 : (this.m21 != 0 ? this.m21 < 0 : this.m22 < 0);
    }

    @Override
    public <T> T getZ(T x, T y, T z) {
        return this.m20 != 0 ? x : (this.m21 != 0 ? y : z);
    }

    @Override
    public int[] getAsArray() {
        return new int[]{this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22};
    }

    @Override
    public boolean isIdentity() {
        return this.m00 == 1 && this.m01 == 0 && this.m02 == 0 && this.m10 == 0 && this.m11 == 1 && this.m12 == 0 && this.m20 == 0 && this.m21 == 0 && this.m22 == 1;
    }
}

