/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2598;
import net.minecraft.class_2802;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.network.CreativeByteBuf;
import team.creative.creativecore.common.network.CreativeNetworkClient;
import team.creative.creativecore.common.network.CreativeNetworkPacket;
import team.creative.creativecore.common.network.CreativePacket;

public class CreativeNetwork {
    public final class_2960 CHANNEL;
    private final HashMap<Class<? extends CreativePacket>, CreativeNetworkPacket> packetTypes = new HashMap();
    private final Logger logger;
    private final String modid;
    private int id = 0;

    public static boolean isSideOnlyPresent(Field field) {
        return field.isAnnotationPresent(Environment.class);
    }

    public CreativeNetwork(int version, Logger logger, class_2960 location) {
        this.logger = logger;
        this.CHANNEL = location;
        this.modid = location.method_12836();
        this.logger.debug("Created network " + String.valueOf(location));
    }

    public <T extends CreativePacket> void registerType(Class<T> classType, Supplier<T> supplier) {
        CreativeNetworkPacket handler = new CreativeNetworkPacket(class_2960.method_43902((String)this.modid, (String)("" + this.id)), classType, supplier, true);
        PayloadTypeRegistry.playC2S().register(handler.sid, class_9139.method_56438((x, y) -> handler.write(x, (CreativeByteBuf)((Object)y), class_2598.field_11942), x -> {
            Object packet = handler.read((CreativeByteBuf)((Object)x), class_2598.field_11942);
            ((CreativePacket)packet).setType(handler.sid);
            return packet;
        }));
        PayloadTypeRegistry.playS2C().register(handler.sid, class_9139.method_56438((x, y) -> handler.write(x, (CreativeByteBuf)((Object)y), class_2598.field_11941), x -> {
            Object packet = handler.read((CreativeByteBuf)((Object)x), class_2598.field_11941);
            ((CreativePacket)packet).setType(handler.sid);
            return packet;
        }));
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            CreativeNetworkClient.registerClientType(handler);
        }
        ServerPlayNetworking.registerGlobalReceiver(handler.sid, (payload, context) -> {
            try {
                context.server().execute(() -> payload.execute((class_1657)context.player()));
            }
            catch (Throwable e) {
                CreativeCore.LOGGER.error("Executing a packet ran into an exception", e);
                CreativeCore.LOGGER.catching(e);
                throw e;
            }
        });
        this.packetTypes.put(classType, handler);
        ++this.id;
    }

    public CreativeNetworkPacket getPacketType(Class<? extends CreativePacket> clazz) {
        return this.packetTypes.get(clazz);
    }

    protected <T extends CreativePacket> T prepare(T packet, class_2598 flow) {
        packet.setType(this.packetTypes.get(packet.getClass()).sid);
        return packet;
    }

    public void sendToServer(CreativePacket message) {
        ClientPlayNetworking.send((class_8710)this.prepare(message, class_2598.field_11942));
    }

    public void sendToClient(CreativePacket message, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)this.prepare(message, class_2598.field_11941));
    }

    public void sendToClient(CreativePacket message, class_1937 level, class_2338 pos) {
        if (level instanceof ISubLevel) {
            this.sendToClientTracking(message, ((ISubLevel)level).getHolder());
        } else {
            this.sendToClient(message, level.method_8500(pos));
        }
    }

    public void sendToClient(CreativePacket message, class_2818 chunk) {
        CreativePacket p = this.prepare(message, class_2598.field_11941);
        for (class_3222 player : ((class_3218)chunk.method_12200()).method_14178().field_17254.method_17210(chunk.method_12004(), false)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)p);
        }
    }

    public void sendToClientTracking(CreativePacket message, class_1297 entity) {
        class_1937 class_19372 = entity.method_73183();
        if (class_19372 instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)class_19372;
            this.sendToClientTracking(message, sub.getHolder());
        } else {
            CreativePacket p = this.prepare(message, class_2598.field_11941);
            class_2802 class_28022 = entity.method_73183().method_8398();
            if (class_28022 instanceof class_3215) {
                class_3215 chunkCache = (class_3215)class_28022;
                chunkCache.method_18754(entity, ServerPlayNetworking.createS2CPacket((class_8710)p));
            }
        }
    }

    public void sendToClientTrackingAndSelf(CreativePacket message, class_1297 entity) {
        class_1937 class_19372 = entity.method_73183();
        if (class_19372 instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)class_19372;
            this.sendToClientTrackingAndSelf(message, sub.getHolder());
        } else {
            CreativePacket p = this.prepare(message, class_2598.field_11941);
            class_2802 class_28022 = entity.method_73183().method_8398();
            if (class_28022 instanceof class_3215) {
                class_3215 chunkCache = (class_3215)class_28022;
                chunkCache.method_18751(entity, ServerPlayNetworking.createS2CPacket((class_8710)p));
            }
        }
    }

    public void sendToClientAll(MinecraftServer server, CreativePacket message) {
        this.prepare(message, class_2598.field_11941);
        for (class_3222 player : PlayerLookup.all((MinecraftServer)server)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)message);
        }
    }
}

