/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.holder;

import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_7225;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.api.ICreativeConfig;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.core.ICreativeRegistry;
import team.creative.creativecore.common.config.holder.ConfigHolder;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;

public class ConfigHolderObject
extends ConfigHolder<ConfigKey> {
    public final Object object;
    private final ICreativeRegistry registry;

    public static ConfigHolderObject createUnrelated(ICreativeRegistry registry, Side side, Object value) {
        return ConfigHolderObject.createUnrelated(registry, side, value, value);
    }

    public static ConfigHolderObject createUnrelated(ICreativeRegistry registry, Side side, Object value, Object defaultReference) {
        return new ConfigHolderObject(ConfigTypeConveration.FAKE_PARENT, side.isClient() ? ConfigSynchronization.CLIENT : ConfigSynchronization.SERVER, registry, "", value, defaultReference);
    }

    public static List<Field> collectFields(Class clazz, List<Field> fields, ICreativeRegistry registry) {
        if (clazz.getSuperclass() != Object.class) {
            ConfigHolderObject.collectFields(clazz.getSuperclass(), fields, registry);
        }
        Field[] declaredFields = clazz.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            if (!registry.is(declaredFields[i])) continue;
            fields.add(declaredFields[i]);
        }
        return fields;
    }

    public ConfigHolderObject(ICreativeConfigHolder parent, ConfigSynchronization synchronization, String key, Object object) {
        this(parent, synchronization, key, object, object);
    }

    public ConfigHolderObject(ICreativeConfigHolder parent, ConfigSynchronization synchronization, String key, Object object, Object defaultReference) {
        this(parent, synchronization, parent.getRegistry(), key, object, defaultReference);
    }

    private ConfigHolderObject(ICreativeConfigHolder parent, ConfigSynchronization synchronization, ICreativeRegistry registry, String key, Object object, Object defaultReference) {
        super(parent, key, synchronization);
        this.object = object;
        this.registry = registry;
        List<Field> fields = ConfigHolderObject.collectFields(object.getClass(), new ArrayList<Field>(), registry);
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            String name = field.getName();
            ConfigSynchronization fieldSync = synchronization;
            boolean requiresRestart = false;
            boolean hideFromGUI = false;
            if (field.isAnnotationPresent(CreativeConfig.class)) {
                CreativeConfig config = field.getAnnotation(CreativeConfig.class);
                if (!config.name().isEmpty()) {
                    name = config.name();
                }
                fieldSync = synchronization != ConfigSynchronization.UNIVERSAL ? synchronization : config.type();
                requiresRestart = config.requiresRestart();
                hideFromGUI = config.hideFromGUI();
            }
            try {
                this.fields.add(name, ConfigKey.of(this, field, name, field.get(defaultReference), fieldSync, requiresRestart, hideFromGUI, object));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }

    @Override
    public ICreativeRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void restoreDefault(Side side, boolean ignoreRestart) {
        super.restoreDefault(side, ignoreRestart);
        this.configured(side);
    }

    @Override
    public void load(class_7225.class_7874 provider, boolean loadDefault, boolean ignoreRestart, JsonObject json, Side side) {
        super.load(provider, loadDefault, ignoreRestart, json, side);
        this.configured(side);
    }

    @Override
    public void configured(Side side) {
        Object object = this.object;
        if (object instanceof ICreativeConfig) {
            ICreativeConfig c = (ICreativeConfig)object;
            c.configured(side);
        }
    }
}

