/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.simple;

import java.util.function.Consumer;
import team.creative.creativecore.client.gui.control.simple.GuiClientButton;
import team.creative.creativecore.client.gui.extension.GuiExtensionCreator;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.simple.GuiColorPicker;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.util.mc.ColorUtils;

public class GuiClientHexButton
extends GuiClientButton<GuiColorPicker.GuiHexButton>
implements GuiColorPicker.GuiHexButtonDist {
    protected GuiExtensionCreator<GuiClientHexButton, GuiParent> ex = new GuiExtensionCreator(this);
    protected GuiColorPicker picker;
    protected Consumer<Integer> consumer;
    private boolean updateCall;

    public GuiClientHexButton(GuiColorPicker.GuiHexButton control) {
        super(control);
    }

    @Override
    public void setConsumer(GuiColorPicker picker, Consumer<Integer> consumer) {
        this.picker = picker;
        this.pressed = x -> this.ex.toggle(this::createBox, GuiExtensionCreator.ExtensionDirection.RIGHT);
        this.consumer = consumer;
    }

    @Override
    public void colorChanged() {
        if (this.ex.hasExtension()) {
            this.updateCall = true;
            this.ex.get().get("hex", GuiTextfield.class).setText(this.picker.color.hex());
        }
    }

    protected GuiParent createBox(GuiExtensionCreator<GuiClientHexButton, GuiParent> creator) {
        GuiParent parent = new GuiParent(((GuiColorPicker.GuiHexButton)this.control).getParent());
        GuiTextfield text = new GuiTextfield(parent, "hex").setText(this.picker.color.hex()).setHexOnly().setMaxStringLength(6);
        parent.add((GuiControl)text.setDim(42, 8));
        parent.registerEventChanged(x -> {
            if (this.updateCall) {
                this.updateCall = false;
            } else {
                this.consumer.accept(ColorUtils.fromHex(text.getText()));
            }
        });
        return parent;
    }
}

