/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.environment.pocket;

import java.util.HashMap;
import team.creative.ambientsounds.engine.AmbientEngine;
import team.creative.ambientsounds.environment.feature.AmbientFeature;
import team.creative.ambientsounds.environment.pocket.BlockDistribution;
import team.creative.creativecore.common.util.type.map.HashMapDouble;

public class AirPocket {
    public final HashMapDouble<String> features = new HashMapDouble();
    public final double averageLight;
    public final double averageBlockLight;
    public final double averageSkyLight;
    public final double air;
    public final double sky;

    public AirPocket() {
        this.averageLight = 15.0;
        this.averageBlockLight = 15.0;
        this.averageSkyLight = 15.0;
        this.air = 1.0;
        this.sky = 1.0;
    }

    public AirPocket(AmbientEngine engine, HashMap<String, BlockDistribution> distribution, double averageLight, double averageBlockLight, double averageSkyLight, double air, int sky) {
        this.averageLight = averageLight;
        this.averageBlockLight = averageBlockLight;
        this.averageSkyLight = averageSkyLight;
        this.air = air < engine.airMin ? 0.0 : (air > engine.airMax ? 1.0 : (air - engine.airMin) / (engine.airMax - engine.airMin));
        this.sky = sky < engine.skyMinCount ? 0.0 : (sky > engine.skyMaxCount ? 1.0 : (double)(sky - engine.skyMinCount) / (double)(engine.skyMaxCount - engine.skyMinCount));
        for (AmbientFeature feature : engine.features.values()) {
            double volume = feature.volume(distribution);
            if (!(volume > 0.0)) continue;
            this.features.put((Object)feature.name, Double.valueOf(volume));
        }
    }

    public double volume(String[] features) {
        double volume = 0.0;
        for (int i = 0; i < features.length; ++i) {
            volume = Math.max(volume, (Double)this.features.getOrDefault((Object)features[i], (Object)0.0));
        }
        return volume;
    }
}

